<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Facades\DB;

class CowsExport implements FromCollection,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {         
        return DB::table('cow')
            ->leftjoin('cow as sire', 'cow.sire_cow_id', '=', 'sire.cow_id')
            ->leftjoin('cow as dam', 'cow.dam_cow_id', '=', 'dam.cow_id')
            ->selectRaw('cow.private_herd_no,cow.cow_name,cow.sex,cow.color,cow.birth_date,cow.birth_weight,
            cow.wean_date,cow.wean_weight,cow.wean_length,cow.wean_high,cow.wean_chest, 
            cow.release_date,cow.release_weight,cow.release_length,cow.release_high,cow.release_chest, 
            cow.cow_status_id,
            (case 
                when not isnull(cow.sire_cow_id) then concat(sire.private_herd_no,\' | \',sire.regisno1)
                else cow.sire
                end) as sire,
            (case 
                when not isnull(cow.dam_cow_id) then concat(dam.private_herd_no,\' | \',dam.regisno1)
                else cow.dam
                end) as dam
            ')
            ->get();
    }

    public function headings(): array
    {
        return [
            'private_herd_no',
            'cow_name', 
            'sex', 
            'color', 
            'birth_date', 
            'birth_weight',
            'wean_date', 
            'wean_weight',
            'wean_chest', 
            'wean_high', 
            'wean_length',  
            'release_date', 
            'release_weight', 
            'release_chest',
            'release_high', 
            'release_length', 
            'cow_status_id',
            'sire',
            'dam'];
    }
}
