<?php
use Illuminate\Support\Facades\DB;
if (! function_exists('getCowTreeByCowID')) {
  function getCowTreeByCowID($cow_id){
    $parent='';
    $grand_father1='';
    $grand_mother1='';
    $great_grand_father1='';
    $great_grand_mother1='';
    $great_grand_father2='';
    $great_grand_mother2='';

    $cowData = DB::table('cow')                
            ->select('cow_id','private_herd_no','cow_name','regisno1','sex','sire_cow_id','dam_cow_id','sire', 'dam','grand_father1', 'grand_father2','grand_mother1', 'grand_mother2')
            ->whereraw("cow_id={$cow_id}")
                        ->first();
    if($cowData !=null){
        $parent=generateCowText($cowData);
        $grand_father_cow_id=$cowData->sire_cow_id;
        $grand_mother_cow_id=$cowData->dam_cow_id;
        
        if($grand_father_cow_id !='')
        {
            $grand_father1_Data = DB::table('cow')
                ->whereraw("cow_id={$grand_father_cow_id}")
                ->select('private_herd_no','cow_name','regisno1','sex'
                        ,'sire_cow_id', 'dam_cow_id')
                ->first();
            if($grand_father1_Data!=null){
                $grand_father1=generateCowText($grand_father1_Data);
                $great_grand_father1_cow_id=$grand_father1_Data->sire_cow_id;
                $great_grand_mother1_cow_id=$grand_father1_Data->dam_cow_id;
                
                if($great_grand_father1_cow_id !='')
                {
                    $great_grand_father1_Data = DB::table('cow')
                        ->whereraw("cow_id={$great_grand_father1_cow_id}")
                        ->select('private_herd_no','cow_name','regisno1','sex'
                                )
                        ->first();
                    if($great_grand_father1_Data!=null){
                        $great_grand_father1=generateCowText($great_grand_father1_Data);
                    }
                }

                if($great_grand_mother1_cow_id !='')
                {
                    $great_grand_mother1_Data = DB::table('cow')
                        ->whereraw("cow_id={$great_grand_mother1_cow_id}")
                        ->select('private_herd_no','cow_name','regisno1','sex')
                        ->first();
                    if($great_grand_mother1_Data!=null){
                        $great_grand_mother1=generateCowText($great_grand_mother1_Data);
                    }
                }                
            }
        }

        if($grand_mother_cow_id !='')
        {
            $grand_mother1_Data = DB::table('cow')
                ->whereraw("cow_id={$grand_mother_cow_id}")
                ->select('private_herd_no','cow_name','regisno1','sex'
                        ,'sire_cow_id', 'dam_cow_id')
                ->first();
            if($grand_mother1_Data!=null){
                $grand_mother1=generateCowText($grand_mother1_Data);
                $great_grand_father2_cow_id=$grand_mother1_Data->sire_cow_id;
                $great_grand_mother2_cow_id=$grand_mother1_Data->dam_cow_id;
                
                if($great_grand_father2_cow_id !='')
                {
                    $great_grand_father2_Data = DB::table('cow')
                        ->whereraw("cow_id={$great_grand_father2_cow_id}")
                        ->select('private_herd_no','cow_name','regisno1','sex'
                                )
                        ->first();
                    if($great_grand_father2_Data!=null){
                        $great_grand_father2=generateCowText($great_grand_father2_Data);
                    }
                }

                if($great_grand_mother2_cow_id !='')
                {
                    $great_grand_mother2_Data = DB::table('cow')
                        ->whereraw("cow_id={$great_grand_mother2_cow_id}")
                        ->select('private_herd_no','cow_name','regisno1','sex'
                                )
                        ->first();
                    if($great_grand_mother2_Data!=null){
                        $great_grand_mother2=generateCowText($great_grand_mother2_Data);
                    }
                }
            }
        }
        $grand_father1=replaceEmptyText($grand_father1,$cowData->sire);
        $grand_mother1=replaceEmptyText($grand_mother1,$cowData->dam);
        $great_grand_father1=replaceEmptyText($great_grand_father1,$cowData->grand_father1);
        $great_grand_mother1=replaceEmptyText($great_grand_mother1,$cowData->grand_mother1);
        $great_grand_father2=replaceEmptyText($great_grand_father2,$cowData->grand_father2);
        $great_grand_mother2=replaceEmptyText($great_grand_mother2,$cowData->grand_mother2);
    }

    $cowchildinfo="";
    $MINIMUM_COW_AGE_IN_DAYS = 275;
    if($cowData->sex == 1){
        $childcowData = DB::table('cow')
                    ->selectRaw("cow_id,cow_name,private_herd_no,birth_date,datediff(curdate(),birth_date) as age_in_days")
                    ->whereRaw("dam_cow_id={$cow_id} and birth_date=
                    (SELECT max(birth_date) FROM cow where dam_cow_id={$cow_id})")->first();
        if($childcowData != null){

            if($childcowData->birth_date !="0000-00-00" && $childcowData->birth_date !='')
            {
                $ageindays=$childcowData->age_in_days;
                if($ageindays <$MINIMUM_COW_AGE_IN_DAYS){
                    $childbirth_dateText=ConvertFromMYSQLDateToThai($childcowData->birth_date);

                    $cowchildinfo = "แม่วัว {$cowData->private_herd_no} เพิ่งคลอดลูกวัว {$childcowData->private_herd_no} เมื่อ {$childbirth_dateText} ลูกวัวอายุ {$childcowData->age_in_days} วัน";
                }
            }
            else
            {
                $cowchildinfo = "แม่วัว {$cowData->private_herd_no} คลอดลูกวัว {$childcowData->private_herd_no} ,ไม่มีข้อมูลวันเกิดลูกวัว";  
            }
        }      
    }

    $output=array(
        'parent'=>$parent,
        'grand_father1'=>$grand_father1,
        'grand_mother1'=>$grand_mother1,
        'great_grand_father1'=>$great_grand_father1,
        'great_grand_mother1'=>$great_grand_mother1,
        'great_grand_father2'=>$great_grand_father2,
        'great_grand_mother2'=>$great_grand_mother2,
        'cowchildinfo'=>$cowchildinfo
    );
    return $output;
  }
}
if (! function_exists('generateCowTextForEdit')) {
    function generateCowText($cowData,$pageName=''){
        
        if($pageName='ForPedigree')
        {
            if($cowData!=null)
                return $cowData->cow_name ." | ".$cowData->private_herd_no;
            else 
                return '-';
        }
        else{
            if($cowData!=null)
                return $cowData->cow_name ." | ".$cowData->private_herd_no;
            else 
                return '-';
        }
    }
};

if (! function_exists('replaceEmptyText')) {
    function replaceEmptyText($inputText,$replaceText){
        if($inputText=='')
            return $replaceText;
        else
            return $inputText;
    }
};

if (! function_exists('getSexText')) {
    function getSexText($sex_id){
        if($sex_id == 1)
            return "Cow";
        else if($sex_id == 2)
            return "Bull";
        else
            return "-";
    }
}

if (! function_exists('getBreedText')) {
    function getBreedText($breed_id){
        if($breed_id == 1)
            return "Brahman";
        else if($breed_id == 2)
            return "Crossbred";
        else if($breed_id == 3)
            return "Brangus";
        else
            return "";
    }
}
if (! function_exists('get_province')) {
    function get_province(){

        $provinces = DB::table('province')->selectRaw('province_id, 	name_th')->orderByRaw('name_th')->get();
        return $provinces;
    }
}
?>