<?php

if (! function_exists('strtotimeFromThai')) {
    function strtotimeFromThai($inputFormat="d M y",$strDate)
    {
        $day_th_array=array("อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัสบดี","ศุกร์","เสาร์");
        $day_short_th_array=array("อา","จ","อ","พ","พฤ","ศ","ส");

        $month_th_array=array("","มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");
        $month_short_th_array = array("","ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค.");

        $day_array=array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
        $day_short_array=array("Sun","MOn","Tue","Wed","Thu","Fri","Sat");
        
        $month_array=array("","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
        $month_short_array = array("","Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
        $output =$strDate??"";

        if(strlen($inputFormat)>0)
        {
            if(strpos($inputFormat,"F")!==false)
            {//Full text month
                $output=str_replace($month_th_array,$month_array,$output);
            }
            if(strpos($inputFormat,"M")!==false)
            {//abbr month
                $output=str_replace($month_short_th_array,$month_short_array,$output);
            }
            
            if(strpos($inputFormat,"l")!==false)
            {//Full text day of week
                $output=str_replace($day_th_array,$day_array,$output);
            }
            if(strpos($inputFormat,"D")!==false)
            {//abbr day of week
                $output=str_replace($day_short_th_array,$day_short_array,$output);
            }
            
            if(strpos($inputFormat,"Y")!==false)
            {//Year 4 digits
                try{
                    $thaiYear = date("Y",strtotime($output));
                    $output=str_replace($thaiYear,$thaiYear-543,$output);
                }catch (Exception $e) {
                   
                }
            }
            if(strpos($inputFormat,"y")!==false)
            {//Year 2 digits
                try{
                    $thaiYear = date("Y",strtotime($output));
                    $output=str_replace($thaiYear,$thaiYear-43,$output);
                }catch (Exception $e) {
                   
                }
            }
        }
        
        //str_replace
        return strtotime($output);
    }
}

if (! function_exists('ConvertFromMYSQLDateToThai')) {
    function ConvertFromMYSQLDateToThai($strDate,$inputFormat="j M Y")
    {
        if($strDate == null){
            return "";
        }
        else{
            $day_th_array=array("อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัสบดี","ศุกร์","เสาร์");
            $day_short_th_array=array("อา","จ","อ","พ","พฤ","ศ","ส");

            $month_th_array=array("","มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");
            $month_short_th_array = array("","ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค.");

            $day_array=array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
            $day_short_array=array("Sun","MOn","Tue","Wed","Thu","Fri","Sat");
            
            $month_array=array("","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
            $month_short_array = array("","Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
            $output =date($inputFormat,strtotime($strDate));

            if(strlen($inputFormat)>0)
            {
                if(strpos($inputFormat,"Y")!==false)
                {//Year 4 digits
                    try{
                        $thaiYear = date("Y",strtotime($output));
                        $output=str_replace($thaiYear,$thaiYear+543,$output);
                    }catch (Exception $e) {
                    
                    }
                }
                if(strpos($inputFormat,"y")!==false)
                {//Year 2 digits
                    try{
                        $thaiYear = date("y",strtotime($output));
                        $output=str_replace($thaiYear,$thaiYear+43,$output);
                    }catch (Exception $e) {
                    
                    }
                }
                
                if(strpos($inputFormat,"F")!==false)
                {//Full text month
                    $output=str_replace($month_array,$month_th_array,$output);
                }
                if(strpos($inputFormat,"M")!==false)
                {//abbr month
                    $output=str_replace($month_short_array,$month_short_th_array,$output);
                }
                
                if(strpos($inputFormat,"l")!==false)
                {//Full text day of week
                    $output=str_replace($day_array,$day_th_array,$output);
                }
                if(strpos($inputFormat,"D")!==false)
                {//abbr day of week
                    $output=str_replace($day_short_array,$day_short_th_array,$output);
                }
                
            
            }
            
            return $output;
        }
    }
}

if (! function_exists('convertStrToMYSQLDate')) {
    function convertStrToMYSQLDate($inputFormat="d M y",$strDate)
    {
        $output = strtotimeFromThai($inputFormat,$strDate);
        
        if(!$output)
            return null;
        else
            return date("Y-m-d", $output);
    }
}

if (! function_exists('dateDiffInMonth')) {
    function dateDiffInMonth($startDate,$endDate="",$str_interval="m")
    {
        if( is_string( $startDate)) $startDate = date_create( $startDate);
        
        if( is_string( $endDate)){
            if($endDate != "")
                $endDate = date_create( $endDate);
            else
            {
                $endDate = date_create( "now");
            }
        }
        $total=0;
        if($startDate!=""){ 
            $diff = date_diff($startDate, $endDate);

            switch( $str_interval){
                case "y":
                    $total = $diff->y;
                    break;
                case "m":
                    $total= $diff->y * 12 + $diff->m;
                    break;
                case "d":
                    $total = $diff->y * 365.25 + $diff->m * 30 + $diff->d;
                    break;
            }
            if( $diff->invert) $total = -1 * $total;
        }
        
        return $total;
    }
}
?>