<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Cow;
use App\CowSale;
use App\CowImage;
use App\Customer;
use App\Address;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
class CowSalesController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
    }

    public function cowsalebycow($cow_id)
    {
        $cowData=Cow::find($cow_id);
        if($cowData->birth_date!=null){
            $currentDate = new \DateTime;
            $birth_date =new \DateTime($cowData->birth_date);
            $interval = $currentDate->diff($birth_date);
            $interval=$interval->format('%m');
        
            $cowData->birth_date=ConvertFromMYSQLDateToThai($cowData->birth_date);
            $cowData->age_in_months=$interval;
        }
        $cowimageData=CowImage::where('cow_id',$cow_id)->first();

        $cowBuyData=DB::table('customer')
        ->leftjoin('cow_sale', 'customer.customer_id', '=', 'cow_sale.customer_id')
        ->leftJoin('address', 'customer.customer_id', '=', 'address.customer_id')
        ->select('customer.customer_id','customer.customer_name' , 'address.address1 as customer_address1','address.phone_no as customer_phone_no','address.province_id as customer_province_id','address.note as customer_note','cow_sale.sale_status_id','cow_sale.last_sale_date','cow_sale.booking_date','cow_sale.paid_date','cow_sale.delivery_date','cow_sale.send_doc_date','cow_sale_address1', 'cow_sale_province_id', 'cow_sale_phone_no', 'cow_sale_note', 'use_same_address')
        ->whereRaw('cow_sale.cow_id='.$cow_id)
        ->first();
        if($cowBuyData==null){
            $cowBuyData=new CowSale;
        }
        else{
            $cowBuyData->booking_date=ConvertFromMYSQLDateToThai($cowBuyData->booking_date);
            $cowBuyData->paid_date=ConvertFromMYSQLDateToThai($cowBuyData->paid_date);
            $cowBuyData->delivery_date=ConvertFromMYSQLDateToThai($cowBuyData->delivery_date);
            $cowBuyData->send_doc_date=ConvertFromMYSQLDateToThai($cowBuyData->send_doc_date);
        }
        if($cowimageData==null) {
            $cowimageData = new CowImage;
            $cowimageData->cow_id=$cow_id;
            $cowimageData->cow_image_path='noimage.jpg';
        }

        return view('cows.cowsalebycow')->with(['cow_id'=>$cow_id,'cowData'=>$cowData,'cowimageData'=>$cowimageData,
        'cowBuyData'=>$cowBuyData,
        'provinceData'=>get_province()]);
    }

    public function cowsalebycustomer($customer_id)
    {
        $cowBuyData=DB::table('cow')
        ->join('cow_sale', 'cow.cow_id', '=', 'cow_sale.cow_id')
        ->leftjoin('breedenum', 'cow.breed', '=', 'breedenum.breed_id')
        ->leftjoin('sexenum', 'cow.sex', '=', 'sexenum.sex_id')
        ->leftjoin('salestatusenum', 'cow_sale.sale_status_id', '=', 'salestatusenum.sale_status_id')
        ->select('cow.cow_id','cow.regisno1' , 'cow.private_herd_no','cow.cow_name',
        'breedenum.breed_text','sexenum.sex_text','salestatusenum.description','cow_sale.last_sale_date')
        ->whereRaw('cow_sale.customer_id='.$customer_id)
        ->orderByRaw('cow_sale.sale_status_id,cow.private_herd_no')
        ->get();

        return $cowBuyData;
    }

    public function getSummaryCowSale($cow_id)
    { 
        $cowBuyData=DB::table('customer')
        ->join('cow_sale', 'customer.customer_id', '=', 'cow_sale.customer_id')
        ->leftjoin('salestatusenum', 'cow_sale.sale_status_id', '=', 'salestatusenum.sale_status_id')
        ->select('customer.customer_id','customer.customer_name' ,'cow_sale.sale_status_id','cow_sale.last_sale_date','cow_sale.booking_date','cow_sale.paid_date','cow_sale.delivery_date','cow_sale.send_doc_date','salestatusenum.description as sale_status')
        ->whereRaw('cow_sale.cow_id='.$cow_id)->first();

        if($cowBuyData != null)
        {
            return "ข้อมูลขายวัว ".$cowBuyData->customer_name." สถานะ ".$cowBuyData->sale_status." วันที่ทำรายการ ".ConvertFromMYSQLDateToThai($cowBuyData->last_sale_date);;
        }
        else
            return " ไม่พบข้อมูลขายวัว ";
    }
    
    public function storecowsale(Request $request)
    { 
        $customer_id=$request->input('customer_id');
        $cow_id=$request->input('cow_id');
        $request->validate([
            'cow_id' => 'required',
            'customer_id' => 'required',
            'customer_name' => 'required',            
            'booking_date'=> 'required'
        ],
        [
            'cow_id.required' => 'กรุณา เลือกวัว',
            'customer_id.required' => 'กรุณา เลือกลูกค้า',
            'customer_name.required' => 'กรุณา กรอกชื่อลูกค้า',
            'booking_date.required' => 'กรุณาใส่ค่า วันที่จองวัว'
        ]);

        if($customer_id==0){
            $customer = new Customer;
            $address = new Address;
        }
        else{
            $customer=Customer::findOrFail($customer_id);
            $address=Address::where('customer_id',$customer_id)->first();;
            if($address == null)$address = new Address;
        }
    
        $customer->customer_name=$request->input('customer_name');    
        $customer->save();
        
        $customer_id=$customer->customer_id;

        $address->customer_id=$customer_id;
        $address->address_type_id=1;
        $address->address1=$request->input('customer_address1');
        $address->province_id=$request->input('customer_province_id');
        $address->phone_no=$request->input('customer_phone_no');
        $address->note=$request->input('customer_note');
        $address->save();

        $cowsale=CowSale::where('cow_id',$cow_id)->first();

        if($cowsale==null) {
            $cowsale = new CowSale;
            $cowsale->cow_id =$cow_id;
        }
        $cowsale->customer_id =$customer_id;
        $cowsale->booking_date= convertStrToMYSQLDate("d M Y",$request->input('booking_date'));
        $cowsale->paid_date= convertStrToMYSQLDate("d M Y",$request->input('paid_date'));
        $cowsale->delivery_date= convertStrToMYSQLDate("d M Y",$request->input('delivery_date'));
        $cowsale->send_doc_date= convertStrToMYSQLDate("d M Y",$request->input('send_doc_date'));
        //if($request->input('use_same_address')==null)
        //    $cowsale->use_same_address= 0;
        //else 
        //    $cowsale->use_same_address= $request->input('use_same_address');

        //force set use_same_address= 0
	    $cowsale->use_same_address= 0;

        $cowsale->cow_sale_address1=$request->input('cow_sale_address1');
        $cowsale->cow_sale_province_id=$request->input('cow_sale_province_id');
        $cowsale->cow_sale_phone_no=$request->input('cow_sale_phone_no');
        if($cowsale->send_doc_date!=""){
            $cowsale->sale_status_id=4;
            $cowsale->last_sale_date=$cowsale->send_doc_date;
        }
        else if($cowsale->delivery_date!=""){
            $cowsale->sale_status_id=3;
            $cowsale->last_sale_date=$cowsale->delivery_date;
        }
        else if($cowsale->paid_date!=""){
            $cowsale->sale_status_id=2;
            $cowsale->last_sale_date=$cowsale->paid_date;
        }
        else if($cowsale->booking_date!=""){
            $cowsale->sale_status_id=1;
            $cowsale->last_sale_date=$cowsale->booking_date;
        }
        else {
            $cowsale->sale_status_id=0;
        }
        $cowsale->save();

        $successmsg='Cow Updated Successfully';
        return redirect("/cows/{$cow_id}/cowsale")->with('success',$successmsg);
    }

    public function deletebycow(Request $request)
    {
        $cow_id=$request->input('cow_id');
        $cowsale=CowSale::where('cow_id',$cow_id)->first();

        if($cowsale!=null)
        {
            $cowsale->delete();
            $successmsg="Delete Cow Sale Success";
            return redirect("/cows/{$cow_id}/cowsale")->with('success',$successmsg);
        }
    }

    public function getcowbystatus(Request $request)
    {
        $sale_status_id = $request->get('sale_status_id');

        $cowData=DB::table('cow')
        ->leftjoin('cow_sale', 'cow.cow_id', '=', 'cow_sale.cow_id')
        ->join('customer', 'customer.customer_id', '=', 'cow_sale.customer_id')
        ->leftjoin('address', 'customer.customer_id', '=', 'address.customer_id')
        ->leftjoin('province', 'address.province_id', '=', 'province.province_id')
        ->selectRaw('cow.cow_id,cow.private_herd_no,customer.customer_id,customer.customer_name,IFNULL(province.name_th,\'-\') as name_th, IFNULL(address.phone_no,\'-\') as phone_no,address.note,cow_sale.sale_status_id,cow_sale.last_sale_date,datediff(CURRENT_DATE,cow_sale.last_sale_date) as duration')
        ->whereRaw('cow_sale.sale_status_id='.$sale_status_id)
        ->orderByRaw('cow_sale.last_sale_date')
        ->get();

        foreach($cowData as $cow)
        {
            $cow->last_sale_date=ConvertFromMYSQLDateToThai($cow->last_sale_date);
        }
        $data = array(
            'cows'  => $cowData
        );

        return  json_encode($data);
    }
}
