<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Cow;
use App\CowImage;
use App\CowSale;
use App\Location;
use App\Exports\CowsExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage; 

class CowsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {        
        return view('cows.index');
    }

    public function search(Request $request)
    {   
        $query = $request->get('query');
        $criteria_array = json_decode($query,true);
        $where_criteria ='';
        if(isset($criteria_array))
        $noofrecordperpage=10;
        if($request->has('noofrecordperpage')) $noofrecordperpage=$request->input('noofrecordperpage');

        if(isset($criteria_array))
        {
            if($criteria_array['cow_no'] != '')
            {
                $where_criteria = $where_criteria."((cow.private_herd_no like '{$criteria_array['cow_no']}%') or (cow.regisno1 like '{$criteria_array['cow_no']}%') or (cow.rfid like '{$criteria_array['cow_no']}%')) and ";
            }
            
            if($criteria_array['location_id'] != -1)
            {
                $where_criteria = $where_criteria.'cow.location_id ='.$criteria_array['location_id'].' and ';
            }
            if($criteria_array['cow_status_id'] != -1)
            {
                $where_criteria = $where_criteria.'cow.cow_status_id ='.$criteria_array['cow_status_id'].' and ';
            }
            if($criteria_array['note'] !='')
            {
                $where_criteria = $where_criteria."cow.note like '{$criteria_array['note']}%' and ";
            }

            if(strlen($where_criteria)>0)
            {
                $where_criteria = substr($where_criteria ,0,strlen ($where_criteria)-5);
                //if($request->ajax())
            }
            else
            {
                $where_criteria ="1=1";
            }

            $data=DB::table('cow')
                ->leftjoin('breedenum', 'cow.breed', '=', 'breedenum.breed_id')
                ->leftjoin('sexenum', 'cow.sex', '=', 'sexenum.sex_id')
                ->leftjoin('cowstatusenum', 'cow.cow_status_id', '=', 'cowstatusenum.cow_status_id')
                ->leftjoin('location', 'cow.location_id', '=', 'location.location_id')
                ->leftjoin('cow as sire', 'cow.sire_cow_id', '=', 'sire.cow_id')
                ->leftjoin('cow as dam', 'cow.dam_cow_id', '=', 'dam.cow_id')
                ->select(DB::raw('cow.cow_id,cow.regisno1 , cow.private_herd_no,cow.cow_name,sire.private_herd_no as sire_private_herd_no,sire.regisno1 AS sire_regisno1 ,dam.private_herd_no as dam_private_herd_no,dam.regisno1 AS dam_regisno1,cow.note,cow.sire_cow_id,cow.sire,cow.dam_cow_id,cow.dam,
                breedenum.breed_text,sexenum.sex_text,cowstatusenum.cow_status_text,location.location_name,cow.sex as s1,(
                    CASE
                    when cow.sex =1 then (select count(*) from cow c where c.dam_cow_id=cow.cow_id)
                    when cow.sex =2 then (select count(*) from cow c where c.sire_cow_id=cow.cow_id)
                    end
                ) as child_count'))
                ->whereRaw($where_criteria)
                ->orderByRaw('cow.private_herd_no')
                ->paginate($noofrecordperpage);
            return view('inc.cowsearchresult', ['data'=>$data]);
        }
        else
            return view('inc.cowsearchresult');
                        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cowData=new Cow;
        $cowimageData=new CowImage;
        $cowimageData->cow_image_path='noimage.jpg';
        return view('cows.createorupdate')->with(['cow_id'=>0,'cowData'=>$cowData,'cowimageData'=>$cowimageData,
        'summarycowsale'=>'',
        'lastchildtext'=>'',
        'childlisthtml'=>'',
        'cowstatus'=>'NewCow']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($cow_id)
    {
        //$this->validate([]);
        $cowData=Cow::find($cow_id);

        $cowData->birth_date=ConvertFromMYSQLDateToThai($cowData->birth_date);
        $cowData->wean_date=ConvertFromMYSQLDateToThai($cowData->wean_date);
        $cowData->release_date=ConvertFromMYSQLDateToThai($cowData->release_date);
        
        if($cowData->sire_cow_id > 0)
        {
            $sireTree = getCowTreeByCowID($cowData->sire_cow_id);
            if($sireTree!=null)
            {
                $cowData->sire=$sireTree["parent"];
                $cowData->grand_father1=$sireTree["grand_father1"];
                $cowData->grand_mother1=$sireTree["grand_mother1"];
                $cowData->great_grand_father1=$sireTree["great_grand_father1"];
                $cowData->great_grand_mother1=$sireTree["great_grand_mother1"];
                $cowData->great_grand_father2=$sireTree["great_grand_father2"];
                $cowData->great_grand_mother2=$sireTree["great_grand_mother2"];
            }
        }
        if($cowData->dam_cow_id > 0)
        {
            $damTree=getCowTreeByCowID($cowData->dam_cow_id);
            if($damTree!=null)
            {
                $cowData->dam=$damTree["parent"];
                $cowData->grand_father2=$damTree["grand_father1"];
                $cowData->grand_mother2=$damTree["grand_mother1"];
                $cowData->great_grand_father3=$damTree["great_grand_father1"];
                $cowData->great_grand_mother3=$damTree["great_grand_mother1"];
                $cowData->great_grand_father4=$damTree["great_grand_father2"];
                $cowData->great_grand_mother4=$damTree["great_grand_mother2"];
            }
        }
        

        $cowimageData = null;
        $cowimageData = CowImage::where('cow_id',$cow_id)->first();
        if($cowimageData ==null)
        {
            $cowimageData=new CowImage;
            $cowimageData->cow_id=$cow_id;
            $cowimageData->cow_image_path='noimage.jpg';
        }

        $cowsale =new CowSalesController();        
        $summarycowsale=$cowsale->getSummaryCowSale($cow_id);

        $childcowarray = $this->getLastChildCowAndChildCowData($cow_id);
        $lastchildtext=$childcowarray['lastchildtext'];
        $childlisthtml=$childcowarray['childlisthtml'];
        $cowchildstatus=$childcowarray['cowchildstatus'];
        
        return view('cows.createorupdate')->with(['cow_id'=>$cow_id,'cowData'=>$cowData,'cowimageData'=>$cowimageData,'summarycowsale'=>$summarycowsale,'lastchildtext'=>$lastchildtext,'childlisthtml'=>$childlisthtml,'cowchildstatus'=>$cowchildstatus]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {        
        $cow_id=$request->input('cow_id');

        //Validate cow data before save
        $validatemsg=$this->CheckCowDataBeforeSave($cow_id,$request->input('regisno1'),$request->input('rfid'));
        if($validatemsg != '')
        {
            return redirect()->back()->with('error',$validatemsg)->withinput();
        }

        $request->validate([
            'private_herd_no' => 'required',
            'cow_name' => 'required',
            'sire'=> 'required',
            'dam'=> 'required'
        ],
        [
            'private_herd_no.required' => 'กรุณา กรอกค่าหมายเลขตัววัว',
            'cow_name.required' => 'กรุณา กรอกชื่อวัว',
            'sire.required' => 'กรุณาใส่ค่า พ่อวัว',
            'dam.required' => 'กรุณาใส่ค่า แม่วัว'
        ]);
        
        if($cow_id==0)
            $cow = new Cow;
        else
            $cow=Cow::find($cow_id);
        
        //if cow use as dam or sire -> cannot change sex

        $cow->rfid=$request->input('rfid');
        $cow->private_herd_no=$request->input('private_herd_no');
        $cow->regisno1=$request->input('regisno1');
        $cow->regisno2=$request->input('regisno2');
        $cow->cow_name=$request->input('cow_name');
        $cow->breed=$request->input('breed');
        $cow->sex = $request->input('sex');

        $birth_date = $request->input('birth_date');
        $birth_date = convertStrToMYSQLDate("d M Y",$birth_date);
        $cow->birth_date = $birth_date;
        
        $cow->color = $request->input('color');
        $cow->sire_cow_id = $request->input('sire_cow_id');
        $cow->dam_cow_id = $request->input('dam_cow_id');
        $cow->birth_weight = $request->input('birth_weight');

        $wean_date = $request->input('wean_date');
        $wean_date = convertStrToMYSQLDate("d M Y",$wean_date);
        $cow->wean_date = $wean_date ;
        $cow->wean_weight = $request->input('wean_weight');
        $cow->wean_length = $request->input('wean_length');
        $cow->wean_high = $request->input('wean_high');
        $cow->wean_chest = $request->input('wean_chest');

        $release_date = $request->input('release_date');
        $release_date = convertStrToMYSQLDate("d M Y",$release_date);
        $cow->release_date = $release_date;

        $cow->release_weight = $request->input('release_weight');
        $cow->release_length = $request->input('release_length');
        $cow->release_high = $request->input('release_high');
        $cow->release_chest = $request->input('release_chest');
        $cow->cow_status_id = $request->input('cow_status_id');
        $cow->note = $request->input('note');

        if($cow_id ==0) $cow->created_date=date("Y-m-d H:i:s");
        $cow->updated_date=date("Y-m-d H:i:s");
        
        $cow->location_id = $request->input('location_id');
        $cow->is_ai = $request->input('is_ai');
        $cow->horn_status_id = $request->input('horn_status_id');
        $cow->sire = $request->input('sire');
        $cow->dam = $request->input('dam');
        $cow->sire_cow_id=$request->input('sire_cow_id');
        $cow->dam_cow_id=$request->input('dam_cow_id');

        if($cow->sire_cow_id==null)
        {
            $cow->grand_father1 = $request->input('grand_father1');
            $cow->grand_mother1 = $request->input('grand_mother1');
            $cow->great_grand_father1 = $request->input('great_grand_father1');
            $cow->great_grand_mother1 = $request->input('great_grand_mother1');
            $cow->great_grand_father2 = $request->input('great_grand_father2');
            $cow->great_grand_mother2 = $request->input('great_grand_mother2');
        }
        else{
            $cow->grand_father1 = '';
            $cow->grand_mother1 = '';
            $cow->great_grand_father1 = '';
            $cow->great_grand_mother1 = '';
            $cow->great_grand_father2 = '';
            $cow->great_grand_mother2 = '';
        }
        
        if($cow->dam_cow_id==null)
        {
            $cow->grand_father2 = $request->input('grand_father2');
            $cow->grand_mother2 = $request->input('grand_mother2');
            $cow->great_grand_father3 = $request->input('great_grand_father3');
            $cow->great_grand_mother3 = $request->input('great_grand_mother3');
            $cow->great_grand_father4 = $request->input('great_grand_father4');
            $cow->great_grand_mother4 = $request->input('great_grand_mother4');
        }
        else{
            $cow->grand_father2 = '';
            $cow->grand_mother2 = '';
            $cow->great_grand_father3 = '';
            $cow->great_grand_mother3 = '';
            $cow->great_grand_father4 = '';
            $cow->great_grand_mother4 = '';
        }
        $cow->wean_status_id =  $request->input('wean_status_id');
        $cow->save();
        $cow_id=$cow->cow_id;
        $cow_image_path=$request->input('cow_image_path');

        $this->SaveImageCow($cow_id,$cow->private_herd_no, $cow_image_path);
        if($cow->sex==1)
            $this->UpdateSireOnChild($cow);
        else
            $this->UpdateDamOnChild($cow);

        //update sire or dam of child
        if($request->input('cow_id')==0)
            $successmsg='Cow Added Successfully';
        else
            $successmsg='Cow Updated Successfully';

        return redirect()->route('cows.index',['cow_no'=>$cow->private_herd_no])->with('success',$successmsg);
    }

    public function searchsire(Request $request)
    {

        if($request->get('query')){
            $query = $request->get('query');
            $where_query="sex=2 and (private_herd_no like '{$query}%' or regisno1 like '{$query}%')";
            $data =DB::table('cow')
                    ->select('cow_id','private_herd_no','regisno1')
                    ->whereRaw($where_query)
                    ->get();

            $total_rows=$data->count();        
            
            if($total_rows)
            {                
                $list_data ='<ul class="cow-tree-dropdown-menu sire-part ui-menu ui-widget ui-widget-content ui-autocomplete ui-front" 
                        style="display:block;
                        postion:relative;width:255px;">';
                foreach($data as $row)
                {
                    $list_data .="<li class=\"ui-menu-item sire-part\" data-id=\"{$row->cow_id}\">
                        <div tabindex=\"-1\" class=\"ui-menu-item-wrapper\">{$row->private_herd_no} | {$row->regisno1}</div></li>";
                }
        
                $list_data .= '</ul>';
            }
            else $list_data="  -- Not Found -- "; 
            $output = array(
                'list_data'=>$list_data,
                'total_data'=>$total_rows
            );
            
            echo json_encode($output);
        }
    }
    public function searchdam(Request $request)
    {
        $query = $request->get('query');
        $where_query="sex=1 and (private_herd_no like '{$query}%' or regisno1 like '{$query}%')";
        $data =DB::table('cow')
                ->select('cow_id','private_herd_no','regisno1')
                ->whereraw($where_query)
                ->get();
        $total_rows=$data->count();        
        if($total_rows > 0)
        {                
            $list_data ='<ul class="cow-tree-dropdown-menu dam-part ui-menu ui-widget ui-widget-content ui-autocomplete ui-front" 
                    style="display:block;
                    postion:relative;width:255px;">';
            foreach($data as $row)
            {
                $list_data .="<li class=\"ui-menu-item dam-part\" data-id=\"{$row->cow_id}\">
                    <div tabindex=\"-1\" class=\"ui-menu-item-wrapper\">{$row->private_herd_no} | {$row->regisno1}</div></li>";
            }
    
            $list_data .= '</ul>';
        }
        else{ $list_data="  -- Not Found -- ";} 
        
        $output = array(
            'list_data'=>$list_data,
            'total_data'=>$total_rows
        );
        
        echo json_encode($output);
    }

    public function search_cow_tree(Request $request){
        $cow_id = $request->get('query');
        echo json_encode(getCowTreeByCowID($cow_id));
    }

    public function exportcowstocsv(){
        //set export file type by using file extension 'cows.xslx' or 'cows.csv'
        return Excel::download(new CowsExport, 'cows.csv');
    }
    
    public function cowregistration()
    {
        return view('cows.cowregistration'); 
    }

    public function searchforregistration(Request $request)
    {
        $query = $request->get('query');
        $criteria_array = json_decode($query,true);
        $where_criteria ='';
        $output='';
        $total_row=0;
        if(isset($criteria_array))
        {
            if($criteria_array['cow_no'] != '')
            {
                $cow_no_criteria='';
                $cow_no=$criteria_array['cow_no'];
                $cow_nos = explode(",", $cow_no);
                foreach($cow_nos as $cow_no_item){
                    if($cow_no_item !=''){
                        $cow_no_criteria = $cow_no_criteria."(cow.private_herd_no like '{$cow_no_item}%' or cow.cow_name like '{$cow_no_item}%' or cow.regisno1 like '{$cow_no_item}%' ) or ";
                    }
                }
                $cow_no_criteria=substr($cow_no_criteria,0,strlen($cow_no_criteria)-4);
                $where_criteria = $where_criteria.'('.$cow_no_criteria.') and ';
            }

            if($criteria_array['location_id'] != -1)
            {
                $where_criteria = $where_criteria.'cow.location_id ='.$criteria_array['location_id'].' and ';
            }
            
            if($criteria_array['cow_status_id'] != -1)
            {
                $where_criteria = $where_criteria.'cow.cow_status_id ='.$criteria_array['cow_status_id'].' and ';
            }

            if($criteria_array['regist_status_id'] == 'NotRegist')
            {
                $where_criteria = $where_criteria.'(cow.regisno1 =\'\' or cow.regisno1 is null) and ';
            }

            if(strlen($where_criteria)>0)
            {
                $where_criteria = substr($where_criteria ,0,strlen ($where_criteria)-5);
                //if($request->ajax())
            }
            else
            {
                $where_criteria ="1=1";
            }

            $data=DB::table('cow')
                ->leftjoin('cow as sire', 'cow.sire_cow_id', '=', 'sire.cow_id')
                ->leftjoin('cow as dam', 'cow.dam_cow_id', '=', 'dam.cow_id')
                ->leftjoin('breedenum', 'cow.breed', '=', 'breedenum.breed_id')
                ->leftjoin('sexenum', 'cow.sex', '=', 'sexenum.sex_id')
                ->leftjoin('colorenum', 'cow.color', '=', 'colorenum.color_id')
                ->leftjoin('location', 'cow.location_id', '=', 'location.location_id')
                ->select('cow.cow_id','cow.private_herd_no', 'cow.regisno1','cow.regisno2','cow.cow_name','cow.birth_date'
                        ,'sire.regisno1 as sire_regisno1','dam.regisno1 as dam_regisno1'
                        , 'breedenum.breed_text','sexenum.description as sex_text','colorenum.description as color_text','location.location_name')
                ->whereRaw($where_criteria)
                ->orderByRaw('cow.private_herd_no')
                ->get();
            return view('inc.cowregistrationresult', ['data'=>$data]);            
        }
        else
            return view('inc.cowregistrationresult'); 
    }

    private function SaveImageCow($cow_id,$private_herd_no,$cow_image_path)
    {
        if($cow_image_path ==null or $cow_image_path =='') 
            $cow_image_path="noimage.jpg";

        if($cow_image_path!="noimage.jpg")
        {
            if(Auth::user()!=null)
                $user = Auth::user()->username;
            else
                $user='';

            $filename = pathinfo($cow_image_path, PATHINFO_FILENAME);
            $extension= pathinfo($cow_image_path, PATHINFO_EXTENSION );
    
            if($filename==$user."_temp")
            {
                $private_herd_no=str_replace('/','_',$private_herd_no);
                $private_herd_no=str_replace('\\','_',$private_herd_no);
                $cow_image_path=$private_herd_no.'_'.time().'.'.$extension;
                $storage_path="public/cow_images/";
                Storage::move($storage_path.$user."_temp.".$extension, $storage_path.$cow_image_path);
            }
        }

        // Create or Update CowImage        
        $cowimage = CowImage::where('cow_id', $cow_id)->first();
        if($cowimage ==null) $cowimage =new CowImage;

        $cowimage->cow_id = $cow_id;      
        $cowimage->cow_image_path = $cow_image_path;
        $cowimage->save();

    }
    private function CheckCowDataBeforeSave($cow_id,$regisno1,$rfid)
    {
        $message_output="";
        $registno1 = trim($regisno1);
        if(strlen($regisno1)>0)
        {
            $cow =DB::table('cow')
            ->select('cow_id','cow_name','regisno1','rfid')
            ->whereraw("cow.regisno1 ='{$regisno1}' and cow.cow_id <> {$cow_id}")
            ->first();
            if($cow!=null)
            {
                $message_output="เลขทะเบียนวัว ซ้ำกับวัวที่มีในระบบ (ชื่อวัวในระบบ = {$cow->cow_name} , เลขทะเบียน = {$cow->regisno1})";
                return $message_output;
            }
        }
        
        $rfid = trim($rfid);
        if(strlen($rfid)>0)
        {
            $cow =DB::table('cow')
            ->select('cow_id','cow_name','regisno1','rfid')
            ->whereraw("cow.rfid ='{$rfid}' and cow.cow_id <> {$cow_id}")
            ->first();
            if($cow!=null)
            {
                $message_output="RFID ซ้ำกับวัวที่มีในระบบ (ชื่อวัวในระบบ = {$cow->cow_name} , RFID = {$cow->rfid})";
                return $message_output;
            }
        }        
        return $message_output;
    }

    Private function UpdateSireOnChild(Cow $cow)
    {
        $NewCowText =generateCowText($cow);
        $affected = DB::table('cow')
              ->where('sire_cow_id', $cow->cow_id)
              ->update(['sire' => $NewCowText]);
    }

    Private function UpdateDamOnChild(Cow $cow)
    {
        $NewCowText =generateCowText($cow);
        $affected = DB::table('cow')
              ->where('dam_cow_id', $cow->cow_id)
              ->update(['dam' => $NewCowText]);
    }

    public function compactview($cow_id)
    {
        $cowData = $this->getCowDataForPedigree($cow_id);
        $cow_image_path=$this->getCowImage($cow_id);

        //***Cow image show only pdf ,not in view***
        return view('cows.compactview',['cowData'=>json_encode( $cowData),'cow_image_path'=>$cow_image_path,'cow_id'=>$cow_id]);
    }

    public function getCowDataForPedigree($cow_id)
    {
        $cow=Cow::find($cow_id);
        $cowData= new \stdClass();
        $cowData->cow_name=$cow->cow_name;
        $cowData->regisno1=$cow->regisno1;
        $cowData->private_herd_no=$cow->private_herd_no;
        $cowData->birth_date=ConvertFromMYSQLDateToThai($cow->birth_date);
        $cowData->sex=getSexText($cow->sex);
        $cowData->breed=getBreedText($cow->breed);
        $cowData->sire=$cow->sire;
        $cowData->dam=$cow->dam;
        if($cow->sire_cow_id>0)
        {
            $sireTree = getCowTreeByCowID($cow->sire_cow_id);
            $cowData->sire=$sireTree["parent"];
            $cowData->grand_father1 = $sireTree["grand_father1"];
            $cowData->grand_mother1 = $sireTree["grand_mother1"];
            $cowData->great_grand_father1 = $sireTree["great_grand_father1"];
            $cowData->great_grand_mother1 = $sireTree["great_grand_mother1"];
            $cowData->great_grand_father2 = $sireTree["great_grand_father2"];
            $cowData->great_grand_mother2 = $sireTree["great_grand_mother2"];
        }
        else
        {
            $cowData->grand_father1 = $cow->grand_father1;
            $cowData->grand_mother1 = $cow->grand_mother1;
            $cowData->great_grand_father1 = $cow->great_grand_father1;
            $cowData->great_grand_mother1 = $cow->great_grand_mother1;
            $cowData->great_grand_father2 = $cow->great_grand_father2;
            $cowData->great_grand_mother2 = $cow->great_grand_mother2;
        }
        if($cow->dam_cow_id>0)
        {
            $damTree = getCowTreeByCowID($cow->dam_cow_id);
            $cowData->dam=$damTree["parent"];
            $cowData->grand_father2 = $damTree["grand_father1"];
            $cowData->grand_mother2 = $damTree["grand_mother1"];
            $cowData->great_grand_father3 = $damTree["great_grand_father1"];
            $cowData->great_grand_mother3 = $damTree["great_grand_mother1"];
            $cowData->great_grand_father4 = $damTree["great_grand_father2"];
            $cowData->great_grand_mother4 = $damTree["great_grand_mother2"];
        }
        else
        {
            $cowData->grand_father2 = $cow->grand_father2;
            $cowData->grand_mother2 = $cow->grand_mother2;
            $cowData->great_grand_father3 = $cow->great_grand_father3;
            $cowData->great_grand_mother3 = $cow->great_grand_mother3;
            $cowData->great_grand_father4 = $cow->great_grand_father4;
            $cowData->great_grand_mother4 = $cow->great_grand_mother4;
        }       
        return $cowData;
    }
    public function getCowImage($cow_id)
    {
        $cow_image_path='noimage.jpg';
        $cowimage = CowImage::where('cow_id', $cow_id)->first();        
        if($cowimage !=null)
        {
            if($cowimage->cow_image_path != '')
            {
                $cow_image_path=$cowimage->cow_image_path;
            }
        }
        return $cow_image_path;
    }
    public function getChildCowFromParentId(Request $request)              
    {
        $cow_id=$request->input('cow_id');
        $cowData = $this->getChildCowData($cow_id);

        $childCowHTML=$this->getChildCowHTML($cowData);

        $data = array(
            'childCowHTML'  => $childCowHTML
        );
        return  json_encode($data);   
    }

    function getChildCowData($cow_id)
    {
        //$cow=Cow::find($cow_id);
        $cowData= DB::table('cow')
        ->leftjoin('sexenum', 'cow.sex', '=', 'sexenum.sex_id')
        ->selectRaw('cow_id,private_herd_no,birth_date,sexenum.sex_text
        ,if(day(CURRENT_DATE)<=day(birth_date)
        ,(year(CURRENT_DATE)*12+month(CURRENT_DATE)-year(birth_date)*12 -month(birth_date)-1)
        ,(year(CURRENT_DATE)*12+month(CURRENT_DATE)-year(birth_date)*12 -month(birth_date))) as age')
        ->whereRaw('sire_cow_id =? or dam_cow_id=?',[$cow_id,$cow_id])
        ->orderByRaw('birth_date DESC')
        ->get();

        foreach($cowData as $cow)
        {
            $cow->birth_date_th=ConvertFromMYSQLDateToThai($cow->birth_date);
        }
       
        return $cowData;
    }

    function getLastChildCowAndChildCowData($cow_id)
    {
        $cowData = $this->getChildCowData($cow_id);

        $lastchildtext=$this->getLastChildCowText($cowData);

        $childlisthtml=$this->getChildCowHTML($cowData);

        $cowchildstatus=$this->getCowChildStatus($cowData);

        $lastchildcowandchildcowdata=array('lastchildtext'=>$lastchildtext,'childlisthtml'=>$childlisthtml,'cowchildstatus'=>$cowchildstatus);
        return $lastchildcowandchildcowdata;
    }

    function getLastChildCowText($cowData)
    {
        if(!is_null($cowData) && count($cowData)>0)
        {
            $lastchildtext ='<a id="lastchildlink" class="text-dark mb-2 ms-1" style="cursor: pointer;font-size: 1rem;">ลูกวัวล่าสุด : '.$cowData[0]->private_herd_no.' - '.$this->validateAndReturnBirthDateAndAgeInText($cowData[0]->birth_date,$cowData[0]->birth_date_th,$cowData[0]->age).'</a>';
        }
        else
        {
            $lastchildtext ='<div>ลูกวัวล่าสุด : - </div>';
        }

        return $lastchildtext;
    }

    function getChildCowHTML($cowData)
    {
        $childlisthtml='';
        if(!is_null($cowData) && count($cowData))
        {
            for($row = 0;$row < count($cowData);$row++)
            {
                $childlisthtml=$childlisthtml.'<tr><td style="text-align:center;">'.$cowData[$row]->private_herd_no.'</td><td style="text-align:center;">'.$cowData[$row]->sex_text.'</td><td style="text-align:center;">'.$this->validateAndReturnBirthDateAndAgeInText($cowData[$row]->birth_date,$cowData[$row]->birth_date_th,$cowData[$row]->age).'</td></tr>';
            }
        }
        else
        {
            $childlisthtml ='';
        }

        return $childlisthtml;
    }
    function getCowChildStatus($cowData)
    {
        //'cowstatus'=>'NewCow';
        if(!is_null($cowData) && count($cowData))
        {
            return 'CowWithChild';
        }
        else
        {
            return 'CowWithOutChild';
        }
    }
    function validateAndReturnBirthDateAndAgeInText($birth_date,$birth_date_th,$age)
    {
        $output ='';
        if(date('Y', strtotime($birth_date))>0)
        {
            $output = $birth_date_th.' ('.$age.'m)';
        }
        else{
            $output = ' - ( - )';
        }
        return $output;
    }    

    public function destroy(Request $request, int $cow_id)
    {
        //check cow has child
        try{
            $cowData= DB::table('cow')
            ->selectRaw('cow_id')
            ->whereRaw('sire_cow_id =? or dam_cow_id=?',[$cow_id,$cow_id])
            ->get();

            if(!is_null($cowData) && count($cowData)>0)
            {
                return redirect()->back()->with('error','Delete cow fail- Cow Has child.')->withinput();      
            }
        }
        catch(\Exception $e)
        {
            return redirect()->back()->with('error','Delete cow fail-'.$e->getMessage())->withinput();  
        }
        
        $outputmsg='';

        try
        {
            $cow = Cow::find($cow_id);
            $outputmsg = $cow->private_herd_no;
            
            //delete cow_sale
            $deletedRows = CowSale::where('cow_id', $cow_id)->delete();

            //delete cow
            $cow->delete();
        
            return redirect()->route('cows.index')->with('success','Delete cow- '.$outputmsg.' - success');
        }
        catch(\Exception $e)
        {
            return redirect()->back()->with('error','Delete cow- '.$outputmsg.' - fail -'.$e->getMessage())->withinput();
        }
    }

}
