<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Customer;
use App\Cow;
use App\CowSale;
use App\Address;
use Illuminate\Support\Facades\Auth;
class CustomersController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {        
        return view('customers.index');
    }

    public function search(Request $request)
    {   
        $query = $request->get('query');
        $criteria_array = json_decode($query,true);
        $where_criteria ='';
        if(isset($criteria_array))
        $noofrecordperpage=10;
        if($request->has('noofrecordperpage')) $noofrecordperpage=$request->input('noofrecordperpage');

        if(isset($criteria_array))
        {
            if($criteria_array['customer_name'] != '')
            {
                $where_criteria = $where_criteria."customer.customer_name like '{$criteria_array['customer_name']}%' and ";
            }
            if($criteria_array['private_herd_no'] != '')
            {
                $where_criteria = $where_criteria."cow.private_herd_no like '{$criteria_array['private_herd_no']}%' and ";
            }
            if($criteria_array['note'] !='')
            {
                $where_criteria = $where_criteria."customer.note like '{$criteria_array['note']}%' and ";
            }

            if(strlen($where_criteria)>0)
            {
                $where_criteria = substr($where_criteria ,0,strlen ($where_criteria)-5);
                //if($request->ajax())
            }
            else
            {
                $where_criteria ="1=1";
            }

            $data=DB::table('customer')
                ->leftJoin('address','customer.customer_id','=','address.customer_id')
                ->leftJoin('province','address.province_id','=','province.province_id')
                ->leftJoin('cow_sale','customer.customer_id','=','cow_sale.customer_id')
                ->leftJoin('cow','cow_sale.cow_id','=','cow.cow_id')
                ->selectraw("DISTINCT customer.customer_id,customer.customer_name,address.address1,province.name_th,address.note")
                ->whereRaw($where_criteria)
                ->orderByRaw('customer.customer_name')
                ->paginate($noofrecordperpage);
            return view('inc.customersearchresult', ['data'=>$data]);
        }
        else
            return view('inc.customersearchresult');
                        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $customerData=new Customer;
        $customerData->address1 ='';
        $customerData->province_id =0;
        $customerData->phone_no ='';
        $customerData->note  = '';
        return view('customers.createorupdate')->with(['customer_id'=>0,'customerData'=>$customerData,'provinceData'=>get_province()]);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($customer_id)
    {
        //$this->validate([]);

        $customerData=DB::table('customer')
                ->leftJoin('address','customer.customer_id','=','address.customer_id')
                ->selectraw("customer.customer_id,customer.customer_name,address.address1,address.phone_no,address.province_id,address.note")
                ->whereRaw("customer.customer_id ={$customer_id}")
                ->first();
        $cowsale =new CowSalesController();
        $cowBuyData=$cowsale->cowsalebycustomer($customer_id);

        return view('customers.createorupdate')->with(['customer_id'=>$customer_id,'customerData'=>$customerData,
        'data'=>$cowBuyData,'provinceData'=>get_province()]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {   
        $customer_id=$request->input('customer_id');

        //Validate data before save

        $request->validate([
            'customer_name' => 'required'
        ],
        [
            'customer_name.required' => 'กรุณา กรอกชื่อลูกค้า'
        ]);
        
        if($customer_id==0){
            $customer = new Customer;
            $address = new Address;
        }
        else{
            $customer=Customer::findOrFail($customer_id);
            $address=Address::where('customer_id',$customer_id)->first();;
            if($address == null)$address = new Address;
        }
        
        $customer->customer_name=$request->input('customer_name');    
        $customer->save();
        
        $customer_id=$customer->customer_id;

        $address->customer_id=$customer_id;
        $address->address_type_id=1;
        $address->address1=$request->input('address1');
        $address->province_id=$request->input('province_id');
        $address->phone_no=$request->input('phone_no');
        $address->note=$request->input('note');
        $address->save();

        $customer->address1=$request->input('address1');
        $customer->province_id=$request->input('province_id');
        $customer->phone_no=$request->input('phone_no');
        $customer->note=$request->input('note');

        if($request->input('add_from_model')=='yes'){
            $data = array(
                'customer'  => $customer
            );
            return  json_encode($data);
        }
        else{
            //update sire or dam of child
            if($request->input('customer_id')==0)
                $successmsg='Customer Added Successfully';
            else
                $successmsg='Customer Updated Successfully';
            return redirect("/customers/{$customer_id}/edit")->with('success',$successmsg);
        }
    }

    public function dosearchforcowsalebycow(Request $request)
    {   
        $customer_name=$request->input('customer_name');
       
        $customers=DB::table('customer')
                ->leftJoin('address','customer.customer_id','=','address.customer_id')
                ->selectraw("customer.customer_id,customer.customer_name,address.address1,address.province_id,address.phone_no,address.note")
                ->whereRaw("customer.customer_name like '{$customer_name}%'")
                ->orderByRaw('customer.customer_name')
                ->get();

        $data = array(
            'customers'  => $customers
        );

        return  json_encode($data);
    }
}
