<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Location;
//use Illuminate\Support\Facades\DB;

class LocationsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $locations=Location::all();
        return view('locations.index')->with('locations',$locations);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('locations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'location_name'=>'required'
        ]);
        
        $location = new Location;
        $location->location_name =$request->input('location_name');
        if(isset($request->is_active))
            $location->is_active =1;
        else
            $location->is_active =0;    
        $location->save();

        return redirect('/locations')->with('success','Location created');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($location_id)
    {
        return Location::find($location_id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($customer_id)
    {
        $location= Location::find($customer_id);        
        return view('locations.edit')->with('location',$location);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $location_id)
    {
        $this->validate($request,[
            'location_name'=>'required'
        ]);
        
        $location = Location::find($location_id);
        $location->location_name =$request->input('location_name');
        if(isset($request->is_active))
            $location->is_active =1;
        else
            $location->is_active =0;
        $location->save();

        return redirect('/locations')->with('success','Location updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($location_id)
    {
        return $location_id;
    }
    public function delete(Request $request)
    {
        $location = Location::find($request->input('location_id'));
        $location->delete();
        return redirect('/locations')->with('success','Location deleted');
    }
    
}
