<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PDF;
use App\Cow;
use App\CowImage;
use Illuminate\Support\Facades\DB;

class PdfController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }
    
    public function cowpedigreepdf($cow_id)
    {
        $cowcontroller = new CowsController();
        $cowData = $cowcontroller->getCowDataForPedigree($cow_id);
        $cow_image_path=$cowcontroller->getCowImage($cow_id);

        //return view('pdf.pedigree',['cowData'=>json_encode( $cowData),'cow_image_path'=>$cow_image_path]);

        //***Cow image show only pdf ,not in view***
        $pdf = PDF::loadView('pdf.pedigree',['cowData'=>json_encode( $cowData),'cow_image_path'=>$cow_image_path]);
        $pdf->setPaper('a4', 'landscape');
        $file_name=$cowData->private_herd_no==""?"cowpedigree.pdf":$cowData->private_herd_no.'.pdf';

        return $pdf->stream($file_name);


        $cow=Cow::find($cow_id);
        $cowData= new \stdClass();
        $cowData->cow_name=$cow->cow_name;
        $cowData->regisno1=$cow->regisno1;
        $cowData->private_herd_no=$cow->private_herd_no;
        $cowData->birth_date=ConvertFromMYSQLDateToThai($cow->birth_date);
        $cowData->sex=getSexText($cow->sex);
        $cowData->breed=getBreedText($cow->breed);
        $cowData->sire=$cow->sire;
        $cowData->dam=$cow->dam;
        if($cow->sire_cow_id>0)
        {
            $sireTree = getCowTreeByCowID($cow->sire_cow_id);
            $cowData->sire=$sireTree["parent"];
            $cowData->grand_father1 = $sireTree["grand_father1"];
            $cowData->grand_mother1 = $sireTree["grand_mother1"];
            $cowData->great_grand_father1 = $sireTree["great_grand_father1"];
            $cowData->great_grand_mother1 = $sireTree["great_grand_mother1"];
            $cowData->great_grand_father2 = $sireTree["great_grand_father2"];
            $cowData->great_grand_mother2 = $sireTree["great_grand_mother2"];
        }
        else
        {
            $cowData->grand_father1 = $cow->grand_father1;
            $cowData->grand_mother1 = $cow->grand_mother1;
            $cowData->great_grand_father1 = $cow->great_grand_father1;
            $cowData->great_grand_mother1 = $cow->great_grand_mother1;
            $cowData->great_grand_father2 = $cow->great_grand_father2;
            $cowData->great_grand_mother2 = $cow->great_grand_mother2;
        }
        if($cow->dam_cow_id>0)
        {
            $damTree = getCowTreeByCowID($cow->dam_cow_id);
            $cowData->dam=$damTree["parent"];
            $cowData->grand_father2 = $damTree["grand_father1"];
            $cowData->grand_mother2 = $damTree["grand_mother1"];
            $cowData->great_grand_father3 = $damTree["great_grand_father1"];
            $cowData->great_grand_mother3 = $damTree["great_grand_mother1"];
            $cowData->great_grand_father4 = $damTree["great_grand_father2"];
            $cowData->great_grand_mother4 = $damTree["great_grand_mother2"];
        }
        else
        {
            $cowData->grand_father2 = $cow->grand_father2;
            $cowData->grand_mother2 = $cow->grand_mother2;
            $cowData->great_grand_father3 = $cow->great_grand_father3;
            $cowData->great_grand_mother3 = $cow->great_grand_mother3;
            $cowData->great_grand_father4 = $cow->great_grand_father4;
            $cowData->great_grand_mother4 = $cow->great_grand_mother4;
        }
        $cowimage = CowImage::where('cow_id', $cow_id)->first();

        $cow_image_path='noimage.jpg';
        if($cowimage !=null)
        {
            if($cowimage->cow_image_path != '')
            {
                $cow_image_path=$cowimage->cow_image_path;
            }
        }

        //***Cow image show only pdf ,not in view***
        //return view('pdf.pedigree',['cowData'=>json_encode( $cowData),'cow_image_path'=>$cow_image_path]);

        $pdf = PDF::loadView('pdf.pedigree',['cowData'=>json_encode( $cowData),'cow_image_path'=>$cow_image_path]);
        $pdf->setPaper('a4', 'landscape');
        $file_name=$cowData->private_herd_no==""?"cowpedigree.pdf":$cowData->private_herd_no.'.pdf';
        return $pdf->stream($file_name);
    }

    public function cowregistrationformpdf(Request $request)
    {
        $cowlist = $request->get('cowList');
        $where_criteria="1=2";
        
        if($cowlist!="") $where_criteria ='cow.cow_id in ('.$cowlist.')';

        $cowData=DB::table('cow')
            ->leftjoin('cow as sire', 'cow.sire_cow_id', '=', 'sire.cow_id')
            ->leftjoin('cow as dam', 'cow.dam_cow_id', '=', 'dam.cow_id')
            ->leftjoin('breedenum', 'cow.breed', '=', 'breedenum.breed_id')
            ->leftjoin('sexenum', 'cow.sex', '=', 'sexenum.sex_id')
            ->leftjoin('colorenum', 'cow.color', '=', 'colorenum.color_id')
            ->leftjoin('location', 'cow.location_id', '=', 'location.location_id')
            ->leftjoin('hornstatusenum', 'cow.horn_status_id', '=', 'hornstatusenum.horn_status_id')
            ->select('cow.cow_id','cow.private_herd_no', 'cow.regisno1','cow.regisno2','cow.cow_name','cow.birth_date','cow.is_ai'
                ,'sire.private_herd_no as sire_private_herd_no','sire.regisno1 as sire_regisno1'
                ,'dam.private_herd_no as dam_private_herd_no','dam.regisno1 as dam_regisno1'
                , 'breedenum.breed_text','sexenum.Description as sex_text','colorenum.Description as color_text','hornstatusenum.Description as horn_status_text','location.location_name')
            ->whereraw($where_criteria)
            ->orderbyraw('cow.private_herd_no')
            ->get();

        foreach($cowData as $cow)
        {
            $cow->birth_date=ConvertFromMYSQLDateToThai($cow->birth_date,"j M y");
            if($cow->is_ai==1) $cow->is_ai='AI';
            else $cow->is_ai='N';
        }
        //return view('pdf.pdfregistrationform',['cowData'=>json_encode( $cowData)]);

        $pdf = PDF::loadView('pdf.pdfregistrationform',['cowData'=>json_encode( $cowData)]);
        $pdf->setPaper('a4', 'landscape');
        return $pdf->stream('registrationform.pdf');
    }
}
