<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use App\CowImage;
use DB;
use Illuminate\Support\Facades\Auth;
class UploadImageController extends Controller
{
    public function __construct()
    {
       // $this->middleware('auth');
    }
    
    public function store(Request $request)
    {   
        $MAX_HEIGH_WIDTH=1000;
        $IMAGE_QUALITY =80;
        $this->validate($request, [
            'cowimagefile' => 'image|nullable|max:5120'
        ]);
        $fileNameToStore = 'noimage.jpg';

        // Handle File Upload
        if($request->hasFile('cowimagefile')){
            // Get filename with the extension
            $filenameWithExt = $request->file('cowimagefile')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('cowimagefile')->getClientOriginalExtension();

            if(Auth::user() !=null)
                $user = Auth::user()->username;
            else
                $user='';

            // Filename to store
            $fileNameToStore= $user.'_temp.'.$extension;            

            $resizeimage = Image::make($request->file('cowimagefile')->getRealPath());
            $resizeimage->resize($MAX_HEIGH_WIDTH, $MAX_HEIGH_WIDTH,   function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            });

            if (file_exists('storage/cow_images/'.$fileNameToStore)) {
                Storage::delete('cow_images/'.$fileNameToStore);
            }
            $resizeimage->save('storage/cow_images/'.$fileNameToStore,$IMAGE_QUALITY);
		
        } else {
            $fileNameToStore = 'noimage.jpg';
        }

        return response()->json(['cow_image_filename' => $fileNameToStore,'msg' => 'Sucess Massage from controller']);
    }
}
