<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
//use Illuminate\Support\Facades\DB;
use Hash;

class UsersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users=User::all();
        return view('users.index')->with('users',$users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user= New User;
        $user->id=0;
        $user->is_admin=0;
        $user->is_active=1;
        return view('users.createorupdate')->with('user',$user);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($user_id)
    {
        $user= User::find($user_id);
        return view('users.createorupdate')->with('user',$user);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user_id=$request->input('user_id');
        if($user_id==0){
            $request->validate([
                'name' => 'required|string|max:255',
                'username' => 'required|string|max:255|unique:users',
            ]);
        }
        else{
            $request->validate([
                'name' => 'required|string|max:255',
                'username' => 'required|string|max:255',
            ]);
        }

        $user_id=$request->input('user_id');
        if($user_id==0){
            $user = new User;
            $user->created_at=date("Y-m-d H:i:s");
        }
        else{
            $user=User::find($user_id);
        }

        $user->name=$request->name;
        $user->username =$request->username;
        $user->is_admin=$request->is_admin??0;
        $user->is_active=$request->is_active??0;
        $user->updated_at=date("Y-m-d H:i:s");
        $user->save();
        
        if($user_id==0 || $request->password!=""){
            $this->savepassword($user->id,$request->password);
        }

        if($user_id==0){
            return redirect('/users')->with('success','User created');
        }
        else{
            return redirect('/users')->with('success','User updated');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changepassword()
    {
        return view('users.changepassword');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storepassword(Request $request)
    {
        $request->validate([          
            'password' => 'required|string|confirmed',
            'password_confirmation' => 'required',
        ]);

        $user_id=$request->input('user_id');
        
        $this->savepassword($user_id,$request->input('password'));

        return redirect()->back()->with('success','change password success');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    private function savepassword($user_id,$new_password)
    {        
        $user=User::find($user_id);        
        $user->password=Hash::make($new_password);
        $user->save();

    }
}
