<?php

namespace App\Http\Controllers\lcauth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use Hash;
use Illuminate\Validation\ValidationException;

class LCAuthController extends Controller
{
    
    public function showLoginForm()
    {
        return view('lcauth.login');
    }

    //
    public function login(Request $request)
    {

        $user = User::where('username', $request->input('username'))->first();
        if($user !=null){
            if($user->is_active == 0)
            {
                throw ValidationException::withMessages([
                    $this->username() => 'User is disabled.']);
            }
            if(Hash::check($request->password,$user->password))
            { 
                Auth::loginUsingId($user->id);
                return redirect()->intended('/dashboard');
            }
        }
        throw ValidationException::withMessages([
            $this->username() => 'Username or Password is incorrect.']);
    }

        /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function username()
    {
        return 'username';
    }

       /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect('/login');
    }

    /**
     * The user has logged out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    protected function loggedOut(Request $request)
    {
        //
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }
}
