<?php

namespace App\Http\Controllers\lcauth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use Hash;

class LCRegisterController extends Controller
{    
    /**
     * Show the application registration form.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm()
    {
        return view('lcauth.register');
    }

    /**
     * Handle a registration request for the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {

        $request->validate([
            'name' => 'required|string|max:255',
            'username' => 'required|string|max:255|unique:users',
            'password' => 'required|string|min:4|confirmed',
            'password_confirmation' => 'required',
            'role' => 'string',
        ]);

        User::create([
          'username' => $request->username,
          'password' => Hash::make($request->password),
          'name' => $request->name,
          'role' => $request->role,
        ]);

        $user = User::where('username', $request->input('username'))->first();
        if($user !=null)
        { 
            Auth::loginUsingId($user->id);
            return redirect()->intended('/dashboard');
        }
           
        return redirect('/');
    }

}
