<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCowSaleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cow_sale', function (Blueprint $table) {
            $table->integer('cow_id');
            $table->integer('customer_id');
            $table->integer('sale_status_id');
            $table->date('last_sale_date')->nullable();
            $table->date('booking_date')->nullable();
            $table->date('paid_date')->nullable();
            $table->date('delivery_date')->nullable();
            $table->date('send_doc_date')->nullable();
            $table->primary('cow_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cow_sale');
    }
}
