@extends('layouts.app')
@section('title',' - จดทะเบียนวัว')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">  
  <style>
      td{
      padding: 0.4rem!important;
    }
  </style>
@endsection
@section('content')

<form method="POST" action="{{action('PdfController@cowregistrationformpdf')}}" id="printregistrationform" target="_blank">
  @csrf
  <input id="cowList" name="cowList" type="hidden">
</form>
<!-- Search Criteria Div-->
  <div style="justify-content:space-between;align-items: flex-end;padding:10px">
    <div class="form-group row mb-1">
      <label for="statusLabel" class="text-right pr-1 col-sm-2 col-form-label">หมายเลขวัว</label>
      <div class="col-3">
        <input class="form-control pb-1" placeholder="พิมพ์หมายเลขวัว" id="cow_no" name="cow_no" type="text">
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="statusLabel" class="text-right pr-1 col-sm-2 col-form-label">สถานะวัว</label>
      <div class="col-3">
        <select name="cow_status_id" id='cow_status_id' class='form-control pb-1'>
          <option value="-1">--ไม่ระบุ--</option>
          @foreach ($cowstatus_array as $cowstatus)
              <option value="{{$cowstatus->cow_status_id}}" {{($cowstatus->cow_status_id==1) ?'selected':''}}>{{ $cowstatus->description}}</option>
          @endforeach
        </select>
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="locationLabel" class="text-right pr-1 col-sm-2 col-form-label">ที่อยู่วัว</label>
      <div class="col-3">
        <select name="location_id" id='location_id' class='form-control pb-1'>
          <option value="-1">-ไม่ระบุ-</option>
          @foreach ($locations_array as $locationitem)   
            <option value="{{ $locationitem->location_id }}">{{ $locationitem->location_name }}</option>
          @endforeach
        </select>
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="registrationStatusLabel" class="text-right pr-1 col-sm-2 col-form-label">สถานะจดทะเบียน</label>
      <div class="col-3">
        <select name="regist_status_id" id='regist_status_id' class='form-control pb-1'>
          <option value="NotRegist">ยังไม่ได้จดทะเบียน</option>
          <option value="All">ทั้งหมด</option>
        </select>
      </div>
      <div class="d-flex justify-content-start col-sm-5">
        <div class="px-0">
          <button class="btn btn-primary" id="btnSearch" type="button">ค้นหา</button>
        </div>
        <div class="px-1">
          <button class="btn btn-secondary ml-1" id="btnPrintRegistrationForm" type="button">พิมพ์</button>
        </div>
        <div class="px-1 ">
          <label for="lblTotalCowSelected" id="lblTotalCowSelected" class="text-left ml-2 col-form-label" style="vertical-align:bottom ;padding-top:17px;"></label>
        </div>
      </div>
    </div>
  </div>
  <div id="table_data">
    @include('inc.cowregistrationresult')
  </div>
<script>
  $(document).ready(function(){    
  
    function create_query()
    {
      var query = new Object();
      query.cow_no = $('#cow_no').val();
      query.cow_status_id = $('#cow_status_id').children("option:selected").val();
      query.location_id = $('#location_id').children("option:selected").val();
      query.regist_status_id = $('#regist_status_id').children("option:selected").val();

      return JSON.stringify(query);
    }

    function fetch_cow_data(query = '')
    {    
      var _token = $('input[name="_token"]').val();
      var data = new FormData();
      data.append("_token", _token);
      data.append("query", create_query()); 
      $.ajax({
        url:"/cows/searchforregistration",
        method:'POST',
        data:data,
        processData: false,
        contentType: false,
        success:function(data)
        {
          $('#table_data').html(data);
        }
      });
    }
  
    $(document).on("click", "#btnSearch",function(e){
      e.preventDefault();
      fetch_cow_data(create_query());
      $('#lblTotalCowSelected').text('เลือกข้อมูล 0 รายการ');
    });

    $(document).on("change", ':checkbox:not("#checkAll")',function(index,value){
      var checkboxCount=$('input:checkbox:not("#checkAll"):checked').length;
      $('#lblTotalCowSelected').text('เลือกข้อมูล '+checkboxCount.toString()+' รายการ');
    });

    $(document).on("change", "#checkAll",function(index,value){
      $(':checkbox:not("#checkAll")').prop('checked', this.checked);
      var checkboxCount=$('input:checkbox:not("#checkAll"):checked').length;
      $('#lblTotalCowSelected').text('เลือกข้อมูล '+checkboxCount.toString()+' รายการ');
    });

    $("#btnPrintRegistrationForm").click(function(){
      var sList='';
      $(':checkbox:not("#checkAll"):checked').each(function(index){
        sList += $(this).val() +',';
      });
      if(sList.length>0) sList=sList.substr(0,sList.length-1);
      $('#cowList').val(sList);
      
      $("#printregistrationform").submit();
    });
  });
</script>
</div>
@endsection