@extends('layouts.app')
@section('title',' - ข้อมูลวัว')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">

  <!-- for Date Picker -->
  <link rel="stylesheet" href="{{asset('css/jquery-ui.css')}}">
  <script src="{{asset('js/jquery-ui-1.11.4.custom.js')}}"></script>
  <link rel="stylesheet" href="{{asset('css/lc_datepicker.css')}}">
  <script src="{{asset('js/lc_datepicker.js')}}"></script>

  <!-- for Cow Tree Div -->
  <link rel="stylesheet" href="{{asset('css/lc_cowtree.css')}}">
  <script src="{{asset('js/lc_cowtree.js')}}"></script>
@endsection
@section('add_to_body')
  
@endsection
@section('content')
<div style="justify-content:space-between;align-items: flex-end;" class="mt-2 ps-2">  
  <form method="POST" action="{{action('CowsController@store')}}" accept-charset="UTF-8" autocomplete="off" id="saveForm">
    @csrf
    <div class="row">
      <label for="private_herd_noLabel" class="cowLabel col-md-1 col-form-label">หมายเลขตัววัว</label>
      <div class="col-md-2 cowInputDiv">
        <input class="cowInput form-control" placeholder="" id="private_herd_no" name="private_herd_no" type="text" value="{{old('private_herd_no', $cowData->private_herd_no)}}">
      </div>

      <label for="rfidLabel" class="cowLabel col-md-1 col-form-label">RFID</label>
      <div class="col-md-3 cowInputDiv">
        <input class="cowInput form-control" placeholder="" id="rfid" name="rfid" type="text" value="{{old('rfid',$cowData->rfid )}}">
      </div>

      <label for="cow_nameLabel" class="cowLabel col-md-1 col-form-label">ชื่อวัว</label>
      <div class="col-md-3 cowInputDiv">
        <input class="cowInput form-control" placeholder="" id="cow_name" name="cow_name" type="text" value="{{old('cow_name',$cowData->cow_name)}}">
      </div>
    </div>

    <div class="row">
      <label for="regisno1Label" class="cowLabel col-md-1 col-form-label">เลขทะเบียนวัว</label>
      <div class="col-md-2 cowInputDiv">
        <input class="cowInput form-control" placeholder="" id="regisno1" name="regisno1" type="text" value="{{old('regisno1',$cowData->regisno1)}}">     
      </div>

      <label for="regisno2Label" class="cowLabel col-md-1 col-form-label">เลขทะเบียนวัว 2</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="regisno2" name="regisno2" type="text" value="{{old('regisno2',$cowData->regisno2)}}">
      </div>
      <label for="sexLabel" class="cowLabel col-md-1 col-form-label">เพศ</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="sex" name="sex" class="cowInput form-control">
          <option value="1" {{(old('sex',$cowData->sex)=='1') ?'selected':''}}>Cow</option>
          <option value="2" {{(old('sex',$cowData->sex)=='2') ?'selected':''}}>Bull</option>
        </select>          
      </div>

      <label for="breedLabel" class="cowLabel col-md-1 col-form-label">พันธุ์</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="breed" name="breed" class="cowInput form-control">
          <option value="1" {{(old('breed',$cowData->breed)=='1') ?'selected':''}}>Brahman</option>
          <option value="2" {{(old('breed',$cowData->breed)=='2') ?'selected':''}}>Crossbred</option>
          <option value="3" {{(old('breed',$cowData->breed)=='3') ?'selected':''}}>Brangus</option>
        </select>     
      </div>

      <label for="colorLabel" class="cowLabel col-md-1 col-form-label">สี</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="color" name="color" class="cowInput form-control">
          <option value="1" {{(old('color',$cowData->color)=='1') ?'selected':''}}>Grey</option>
          <option value="2" {{(old('color',$cowData->color)=='2') ?'selected':''}}>Red</option>
        </select>     
      </div>
    </div>

    <div class="row">
      <label for="birthdateLabel" class="cowLabel col-md-1 col-form-label">วันเกิด</label>
      <div class="col-md-2 cowInputDiv ">
        <input class="datepicker cowInput form-control" placeholder="" id="birth_date" data-date="{{old('birth_date',$cowData->birth_date)}}" name="birth_date" type="text" value="">
      </div>

      <label for="cowage" class="text-left col-md-1 col-form-label" style="font-size:0.8rem;padding-top:0.1rem;" id="cowage">(m)</label>
      <div class="col-md-1 cowInputDiv ">          
      </div>
      
      <label for="birthweightLabel" class="cowLabel col-md-1 col-form-label">นน.แรกเกิด</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="birth_weight" name="birth_weight" type="text" value="{{old('birth_weight',$cowData->birth_weight)}}">
      </div>

      <label for="isaiLabel" class="cowLabel col-md-1 col-form-label">ผสมเทียม</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowCheckbox form-control" placeholder="" id="is_ai" style="margin-top:0.5rem" name="is_ai" type="checkbox" value="1" {{(old('is_ai',$cowData->is_ai) ==1)?'checked':''}}>
      </div>

      <label for="weanstatusLabel" class="cowLabel col-md-1 col-form-label">การคลอด</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="wean_status_id" name="wean_status_id" class="cowInput form-control">
          <option value="1" {{(old('wean_status_id',$cowData->wean_status_id)=='1') ?'selected':''}}>คลอดง่าย</option>
          <option value="2" {{(old('wean_status_id',$cowData->wean_status_id)=='2') ?'selected':''}}>ช่วยคลอด</option>
          <option value="3" {{(old('wean_status_id',$cowData->wean_status_id)=='3') ?'selected':''}}>คลอดยาก</option>
        </select>
      </div>
    </div>

    <div class="row">
      <label for="weandateLabel" class="cowLabel col-md-1 col-form-label">วันหย่านม</label>
      <div class="col-md-2 cowInputDiv ">
        <input class="datepicker cowInput form-control" placeholder="" id="wean_date" data-date="{{old('wean_date',$cowData->wean_date)}}" name="wean_date" type="text" value=""> 
      </div>

      <label for="weanweightLabel" class="cowLabel col-md-1 col-form-label">นน.หย่านม</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="wean_weight" name="wean_weight" type="text" value="{{old('wean_weight',$cowData->wean_weight)}}">
      </div>
      
      <label for="weanchestLabel" class="cowLabel col-md-1 col-form-label">รอบอกหย่านม</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="wean_chest" name="wean_chest" type="text" value="{{old('wean_chest',$cowData->wean_chest )}}">
      </div>

      <label for="weanhighLabel" class="cowLabel col-md-1 col-form-label">ส่วนสูงหย่านม</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="wean_high" name="wean_high" type="text" value="{{old('wean_high',$cowData->wean_high)}}">
      </div>

      <label for="weanlengthLabel" class="cowLabel col-md-1 col-form-label">ความยาวหย่านม</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="wean_length" name="wean_length" type="text" value="{{old('wean_length',$cowData->wean_length)}}">
      </div>
    </div>

    <div class="row">
      <label for="releasedateLabel" class="cowLabel col-md-1 col-form-label">วันจำหน่าย</label>
      <div class="col-md-2 cowInputDiv ">
        <input class="datepicker cowInput form-control" placeholder="" id="release_date" data-date="{{old('release_date',$cowData->release_date)}}" name="release_date" type="text" value="">
      </div>

      <label for="releaseweightLabel" class="cowLabel col-md-1 col-form-label">นน.จำหน่าย</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="release_weight" name="release_weight" type="text" value="{{old('release_weight',$cowData->release_weight)}}">
      </div>
      
      <label for="releasechestLabel" class="cowLabel col-md-1 col-form-label">รอบอกจำหน่าย</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="release_chest" name="release_chest" type="text" value="{{old('release_chest',$cowData->release_chest )}}">
      </div>

      <label for="releasehighLabel" class="cowLabel col-md-1 col-form-label">ส่วนสูงจำหน่าย</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="release_high" name="release_high" type="text" value="{{old('release_high',$cowData->release_high)}}">
      </div>

      <label for="releaselengthLabel" class="cowLabel col-md-1 col-form-label">ความยาวจำหน่าย</label>
      <div class="col-md-1 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="release_length" name="release_length" type="text" value="{{old('release_length',$cowData->release_length)}}">
      </div>
    </div>

    <div class="row">
      <label for="cowstatusidLabel" class="cowLabel col-md-1 col-form-label">สถานะ</label>
      <div class="col-md-2 cowInputDiv ">
        <select id="cow_status_id" name="cow_status_id" class="cowInput form-control">
          <option value="0" {{(old('cow_status_id',$cowData->cow_status_id)=='0') ?'selected':''}}>ไม่ระบุ</option>
          <option value="1" {{(old('cow_status_id',$cowData->cow_status_id)=='1') ?'selected':''}}>ในฟาร์ม</option>
          <option value="11" {{(old('cow_status_id',$cowData->cow_status_id)=='11') ?'selected':''}}>ขาย</option>
          <option value="13" {{(old('cow_status_id',$cowData->cow_status_id)=='13') ?'selected':''}}>ตาย</option>
          <option value="2" {{(old('cow_status_id',$cowData->cow_status_id)=='2') ?'selected':''}}>น้ำเชื้อนำเข้า</option>
        </select>     
      </div>

      <label for="hornstatusidLabel" class="cowLabel col-md-1 col-form-label">สถานะเขา</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="horn_status_id" name="horn_status_id" class="cowInput form-control">
          <option value="1" {{(old('horn_status_id',$cowData->horn_status_id)=='1') ?'selected':''}}>Horned</option>
          <option value="2" {{(old('horn_status_id',$cowData->horn_status_id)=='2') ?'selected':''}}>Dehorned</option>
          <option value="3" {{(old('horn_status_id',$cowData->horn_status_id)=='3') ?'selected':''}}>Pulled</option>
        </select>    
      </div>
      
      <label for="noteLabel" class="cowLabel col-md-1 col-form-label">หมายเหตุ</label>
      <div class="col-md-3 cowInputDiv ">
        <input class="cowInput form-control" placeholder="" id="note" name="note" type="text" value="{{old('note',$cowData->note)}}">
      </div>

      <label for="locationLabel" class="cowLabel col-md-1 col-form-label">ที่อยู่</label>
      <div class="col-md-1 cowInputDiv ">
        <select id="location_id" name="location_id" class="cowInput form-control">
          <option value="-1">-ไม่ระบุ-</option>
          @foreach ($locations_array as $locationitem)   
            <option value="{{ $locationitem->location_id }}" {{(old('location_id',$cowData->location_id) ==$locationitem->location_id) ?'selected':''}}>{{ $locationitem->location_name }}</option>
          @endforeach
        </select>
      </div>      
    </div>
    <div id="tree-view-and-picutre" class="container-xxl" style="min-width:1024px;">

      <div class="row">
      <div id="tree-view-wrapper" class="col-8" >
        <input type="hidden" value="{{old('sire_cow_id',$cowData->sire_cow_id)}}" id="sire_cow_id" name="sire_cow_id">
        <input type="hidden" value="{{old('dam_cow_id',$cowData->dam_cow_id)}}" id="dam_cow_id" name="dam_cow_id" >
        <label style="position: absolute;left:5px;top:30px">Sire</label>
        <label style="position: absolute;left:5px;top:180px">Dam</label>
      
        <div id="divSire" class="root"><input name="sire" id="sire" value="{{old('sire',$cowData->sire)}}" class="input-cow-tree sire-part root" type="text">
          <div id="sireList" style="display:none;width:270px" z-index=1></div>
          <button id="removeSirePart" name="removeSirePart" class="remove-cow-tree sire-part root" tabindex="-1"><i class="fas fa-minus-circle"></i></button>          
          <div class="branch lv1 sire-part">
            <div class="entry sire-part"><input name="grand_father1" id="grand_father1" value="{{old('grand_father1',$cowData->grand_father1)}}" class="input-cow-tree sire-part" type="text">
              <div class="branch lv2 sire-part">
                <div class="entry sire-part"><input name="great_grand_father1" id="great_grand_father1" value="{{old('great_grand_father1',$cowData->great_grand_father1)}}" class="input-cow-tree sire-part" type="text"></div>
                <div class="entry sire-part"><input name="great_grand_mother1" id="great_grand_mother1" value="{{old('great_grand_mother1',$cowData->great_grand_mother1)}}" class="input-cow-tree sire-part" type="text"></div>
              </div>
            </div>
            <div class="entry sire-part"><input name="grand_mother1" id="grand_mother1" value="{{old('grand_mother1',$cowData->grand_mother1)}}" class="input-cow-tree sire-part" type="text">
              <div class="branch lv2 sire-part">
                <div class="entry sire-part"><input name="great_grand_father2" id="great_grand_father2" value="{{old('great_grand_father2',$cowData->great_grand_father2)}}" class="input-cow-tree sire-part" type="text"></div>
                <div class="entry sire-part"><input name="great_grand_mother2" id="great_grand_mother2" value="{{old('great_grand_mother2',$cowData->great_grand_mother2)}}" class="input-cow-tree sire-part" type="text"></div>
              </div>
            </div> 
          </div>
          <div id="sireLoading" style="position: absolute;top:90px;left:10px;display:none">
            <div class="spinner-border text-muted" style="width:1rem;height: 1rem;"></div> Loading
          </div>
        </div>
        <div id="divDam" class="root">
          <input name="dam" id="dam" value="{{old('dam',$cowData->dam)}}" class="input-cow-tree dam-part root" type="text">
          <div id="damList" style="display:none" z-index=1></div>
          <button id="removeDamPart" name="removeDamPart" class="remove-cow-tree dam-part root" tabindex="-1"><i class="fas fa-minus-circle"></i></button>
          <div class="branch lv1 dam-part">
            <div class="entry dam-part"><input name="grand_father2" id="grand_father2" value="{{old('grand_father2',$cowData->grand_father2)}}" class="input-cow-tree dam-part" type="text">
              <div class="branch lv2 dam-part">
                <div class="entry dam-part"><input name="great_grand_father3" id="great_grand_father3" value="{{old('great_grand_father3',$cowData->great_grand_father3)}}" class="input-cow-tree dam-part" type="text"></div>
                <div class="entry dam-part"><input name="great_grand_mother3" id="great_grand_mother3" value="{{old('great_grand_mother3',$cowData->great_grand_mother3)}}" class="input-cow-tree dam-part" type="text"></div>
              </div>
            </div>
            <div class="entry dam-part"><input name="grand_mother2" id="grand_mother2" value="{{old('grand_mother2',$cowData->grand_mother2)}}" class="input-cow-tree dam-part" type="text">
              <div class="branch lv2 dam-part">
                <div class="entry dam-part"><input name="great_grand_father4" id="great_grand_father4" value="{{old('great_grand_father4',$cowData->great_grand_father4)}}" class="input-cow-tree dam-part" type="text"></div>
                <div class="entry dam-part"><input name="great_grand_mother4" id="great_grand_mother4" value="{{old('great_grand_mother4',$cowData->great_grand_mother4)}}" class="input-cow-tree dam-part" type="text"></div>
              </div>
            </div>            
          </div>
          <div id="damLoading" style="position: absolute;top:90px;left:10px;display:none">
            <div class="spinner-border text-muted" style="width:1rem;height: 1rem;"></div> Loading
          </div>
        </div>
      </div>
      <div class="col p-0 me-2" style="max-width:100%;">
        <div class="m-0 p-0 d-flex flex-column align-items-start" style="height: 260px;max-width: 350px;">
          <div><?php echo $lastchildtext;?></div>
          <a id="imagelink" class="ms-1;" style="cursor: pointer;">
            <img id="cowimage" src="{{'/storage/cow_images/'.$cowimageData->cow_image_path??'/storage/cow_image/noimage.jpg'}}" class="rounded ps-1 pe-3 mb-1 img-fluid" style="max-height:220px;" >
          </a>            
        </div>
        <div style="height: 50px;max-width: 350px;">
            <input type="file" class="form-control form-control-sm" id="cowimagefile" name="cowimagefile" accept=".jpeg, .jpg, .png" hidden/>
            <input type="hidden" value="{{ $cowimageData->cow_image_path}}" id="cow_image_path" name="cow_image_path">
            <label class="ms-1 rounded uploadimagebtn" id="uploadimagebtn" for="cowimagefile"><i class="fas fa-upload"></i> Upload</label>
            <button class="btn btn-primary" type="button" disabled id="uploadimagewaitingbtn" style="display: none">
              <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
              Uploading...
            </button>
            <a class="ms-1 rounded uploadimagebtn" id="delCowImage"><i class="fas fa-trash-alt"></i></a>
        </div>
      </div>
    </div>
    <input id="cow_id" name="cow_id" type="hidden" value="{{$cow_id}}">
  <div class="row m-1">
    <div class="col-4 py-2">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#confirmSaveCowModal" type="button">บันทึก</button>
      <button class="btn btn-outline-secondary" id="btnCancel" type="button">ยกเลิก</button>
    @if(isset($cow_id) and $cow_id > 0)
      <button class="btn btn-secondary" id="btnPrintPedigree" type="button">ใบพันธุ์ประวัติ</button>
    @endif
    @if(isset($cowchildstatus) and $cowchildstatus=='CowWithChild')
      <button class="btn btn-outline-secondary diabled" type="button" title="ไม่สามารถลบวัวที่มีลูกได้">ลบ</button>
    @endif
    @if(isset($cowchildstatus) and $cowchildstatus=='CowWithOutChild')
      <button class="btn btn-outline-danger" type="button" data-bs-toggle="modal" data-bs-target="#confirmDeleteCowModal">ลบ</button>
    @endif
    </div>
    
    @if(isset($cow_id) and $cow_id > 0)
    <div class="border border-secondary rounded col-8 text-end py-2">      
      <div class="d-inline-block fs-7 align-text-bottom pe-2" >{{$summarycowsale??''}}
      </div>
      <div class="d-inline-block align-text-bottom">
        <button class="btn btn-success" id="btnCowOrder">จัดการข้อมูลการขาย</button>
      </div>
    </div>
    @endif
  </div>
  <!-- Modal Cow Child Info-->
  <div class="modal fade" id="cowchildinfoModel" tabindex="-1" role="dialog" aria-labelledby="cowchildinfoLabel" aria-hidden="true" >
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title h5" id="cowchildinfoLabel">มีลูกวัวอายุไม่เกิน 275 วัน</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body h6" style="min-height: 90px" id="cowchildinfoBody">
          
        </div>
      </div>
    </div>
  </div>
  <!-- Modal Confirm Save Cow-->
  <div class="modal fade" id="confirmSaveCowModal" tabindex="-1" role="dialog" aria-labelledby="confirmSaveCowModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmSaveCowModalLabel">บันทึกข้อมูล</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          ต้องการบันทึกข้อมูลวัว
        </div>
        <div class="modal-footer">
          <button type="button" id="confirmModalSaveCowButton" class="btn btn-primary">บันทึกข้อมูล</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        </div>
      </div>
    </div>
  </div>
  </form>
  <!-- Modal Child Cow List-->
  <div class="modal" id="childCowListModal" tabindex="-1" aria-labelledby="childCowListModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <div class="modal-title" id="childCowListModalLabel">Private Herd No. {{$cowData->private_herd_no}}</div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          <table id="tableChildCowList" class="table table-striped table-sm table-bordered table-hover">
            <thead>
              <tr class="thead-light">
                <th scope="col" class="tableHeader" style="width:60px">หมายเลขลูกวัว</th>
                <th scope="col" class="tableHeader" style="width:35px">เพศ</th>
                <th scope="col" class="tableHeader" style="width:140px">วันเกิด</th>
              </tr>
            </thead>
            <tbody>
              <?php echo $childlisthtml; ?>
            </tbody>
          </table> 
        </div>        
      </div>
    </div>
  </div>
  <!--Model Confirm Delete Cow-->
  <!-- Modal -->
  <div class="modal fade" id="confirmDeleteCowModal" tabindex="-1" aria-labelledby="confirmDeleteCowModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmDeleteCowModalLabel">ลบข้อมูลวัว</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          ต้องการลบข้อมูลวัว : {{old('private_herd_no', $cowData->private_herd_no)}} - {{old('cow_name',$cowData->cow_name)}}
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
          <button type="button" class="btn btn-danger" id="confirmModalDeleteCowButton" >ลบข้อมูลวัว</button>
          <button class="btn btn-danger" type="button" disabled id="confirmModalDeleteCowButtonWaiting" style="display: none">
            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
            Deleting...
          </button>
        </div>
      </div>
    </div>
  </div>
  <form action="{{ route('cows.destroy', $cow_id) }}" method="POST" id="deleteForm">
    @csrf
    @method('DELETE')
  </form>
</div>

<script>
  $(document).ready(function(){

    if($("#cow_id").val()!="")
    {
      $("#birth_date").datepicker("setDate", $('#birth_date').data('date'));
      $("#wean_date").datepicker("setDate", $('#wean_date').data('date'));
      $("#release_date").datepicker("setDate", $('#release_date').data('date'));
      $selectDate = $("#birth_date").val();
      if($selectDate!=""){
        $cowAge = GetDurationInMonthFromShortThai($selectDate);
        $("#cowage").text($cowAge);
      }
      formatSireTextbox();
      formatDamTextbox();
    }

    $("#birth_date").change(function(){    
      $selectDate = $("#birth_date").val();
      $cowAge = GetDurationInMonthFromShortThai($selectDate);
      $("#cowage").text($cowAge);
    });

    $('#sire').focusout(function() {
        //$('#sireList').fadeOut();
      })
      .keyup(function(){
        var query = $(this).val();
        if($('#sire_cow_id').val()==''&& query!='' && query.length==4)
        {
          $('#sire').attr('readonly','');
          $('#sireLoading').show();
          $.ajax({
            url:"{{route('cows.searchsire')}}",
            method:'GET',
            data:{query:query},
            dataType:'json',
            success:function(data)
            {
              $('#sireList').fadeIn();
              $('#sireList').html(data.list_data);
              if(data.total_data ==0)
              {
                $('#sireList').fadeOut();
              }
            },
            complete:function(data){             
              $('#sireLoading').hide();
              $('#sire').removeAttr('readonly');
            },
          });
        }
        else{
          $('#sireList').html('');
          $('#sireList').fadeOut();          
          $('#sireLoading').hide();
          if($('#sire_cow_id').val('')=='')
          $('#sire').removeAttr('readonly');
        }       
    });

    $('#dam').focusout(function() {
       //$('#damList').fadeOut();
      })
      .keyup(function(){
        var query = $(this).val();
        if($('#dam_cow_id').val()=='' && query!='' && query.length==4)
        {
          $('#dam').attr('readonly','');
          $('#damLoading').show();
          $.ajax({
            url:"{{route('cows.searchdam')}}",
            method:'GET',
            data:{query:query},
            dataType:'json',
            success:function(data)
            {                
                $('#damList').fadeIn();
                $('#damList').html(data.list_data);                              
                if(data.total_data ==0)
                {
                  $('#damList').fadeOut();
                }
            },
            complete:function(data){
              $('#damLoading').hide();
              $('#dam').removeAttr('readonly');
            },
          })
        }
        else{
          $('#damList').html('');
          $('#damList').fadeOut();          
          $('#damLoading').hide();
          if($('#dam_cow_id').val('')=='')
          $('#dam').removeAttr('readonly');
        }
    });

    $(document).on('click','li.sire-part',function(){
      //console.log($(this));
      $('#sire_cow_id').val($(this).attr( "data-id").trim());
      $('#sire').val($(this).text().trim());    
      query=$('#sire_cow_id').val();
      $('#sireList').fadeOut();

      $.ajax({
        url:"{{route('cows.searchcowtree')}}",
        method:'GET',
        data:{query:query},
        dataType:'json',
        success:function(data)
        {
          formatSireTextbox();
          $('#grand_father1').val(data.grand_father1);
          $('#grand_mother1').val(data.grand_mother1);
          $('#great_grand_father1').val(data.great_grand_father1);
          $('#great_grand_mother1').val(data.great_grand_mother1);
          $('#great_grand_father2').val(data.great_grand_father2);
          $('#great_grand_mother2').val(data.great_grand_mother2);
          $('#sireList').fadeOut();
        }
      })
    });

    $(document).on('click','li.dam-part',function(){
      $('#dam').val($(this).text().trim());
      $('#dam_cow_id').val($(this).attr( "data-id").trim());
      query=$('#dam_cow_id').val();
      $('#damList').fadeOut();

      $.ajax({
        url:"{{route('cows.searchcowtree')}}",
        method:'GET',
        data:{query:query},
        dataType:'json',
        success:function(data)
        {
          formatDamTextbox();
          $('#grand_father2').val(data.grand_father1);
          $('#grand_mother2').val(data.grand_mother1);
          $('#great_grand_father3').val(data.great_grand_father1);
          $('#great_grand_mother3').val(data.great_grand_mother1);
          $('#great_grand_father4').val(data.great_grand_father2);
          $('#great_grand_mother4').val(data.great_grand_mother2);
          if(data.cowchildinfo !=''){
            $('#cowchildinfoBody').text(data.cowchildinfo);
            $('#cowchildinfoModel').modal('show');
          }
          
          $('#damList').fadeOut();
        }
      })
    });

    $(document).on('click','#imagelink',function(){
      src = $('#cowimage').attr('src');
      src_array = src.split('/');
      src_filename = src_array[src_array.length-1];
      if(src_filename!='noimage.jpg' && src_filename!=''){
        window.open(src, '_blank');
      }
    });

    $("#removeSirePart").click(function(){
      event.preventDefault();
      clearSireTextbox();
      formatSireTextbox();
    });

    $("#removeDamPart").click(function(){
      event.preventDefault();
      clearDamTextbox();
      formatDamTextbox();
    });

    $("#confirmModalSaveCowButton").click(function(){
      $('#saveForm').submit();
    });

    $("#btnPrintPedigree").click(function(){
        window.open('/pdf/cowpedigreepdf/{{$cow_id}}', '_blank');
    });

    $("#btnCancel").click(function(){
      event.preventDefault();
      GoBackToPreviousPage();
    });

    function GoBackToPreviousPage()
    {
      if(document.referrer.includes('cows'))
        window.location.href='/cows';
      else if(document.referrer.includes('dashboard'))
        window.location.href='/dashboard';
      else
        close();
    }

    $("#btnCowOrder").click(function(){
      event.preventDefault();
      window.location.href='/cows/{{$cow_id}}/cowsale/';
    });
    
  })

  function formatSireTextbox(){
    
    if( $('#sire_cow_id').val()=='')
    {
      //$('#removeSirePart').attr('disabled', 'disabled');
      $('#sire').removeAttr('readonly');
      $('#sire').focus();
      $('#sireList').html('');
      $('#sireList').hide();          
      $('#sireLoading').hide();
      $('#grand_father1').removeAttr('disabled');
      $('#grand_mother1').removeAttr('disabled');
      $('#great_grand_father1').removeAttr('disabled');
      $('#great_grand_mother1').removeAttr('disabled');
      $('#great_grand_father2').removeAttr('disabled');
      $('#great_grand_mother2').removeAttr('disabled');

      $bgcolor='#fff';
    }
    else
    {
      //$('#removeSirePart').removeAttr('disabled');
      $('#sire').attr('readonly','');
      $('#grand_father1').attr('disabled', 'disabled');
      $('#grand_mother1').attr('disabled', 'disabled');
      $('#great_grand_father1').attr('disabled', 'disabled');
      $('#great_grand_mother1').attr('disabled', 'disabled');
      $('#great_grand_father2').attr('disabled', 'disabled');
      $('#great_grand_mother2').attr('disabled', 'disabled');

      $bgcolor='#ffe5d7';
    }
  
    $('#sire').css("background-color", $bgcolor);
    $('#grand_father1').css("background-color", $bgcolor);
    $('#grand_mother1').css("background-color", $bgcolor);
    $('#great_grand_father1').css("background-color", $bgcolor);
    $('#great_grand_mother1').css("background-color", $bgcolor);
    $('#great_grand_father2').css("background-color", $bgcolor);
    $('#great_grand_mother2').css("background-color", $bgcolor);
  }

  function formatDamTextbox(){
    
    if( $('#dam_cow_id').val()=='')
    {
      //$('#removeDamPart').attr('disabled', 'disabled');
      $('#dam').removeAttr('readonly');
      $('#dam').focus();
      $('#damList').html('');
      $('#damList').hide();          
      $('#damLoading').hide();
      $('#grand_father2').removeAttr('disabled');
      $('#grand_mother2').removeAttr('disabled');
      $('#great_grand_father3').removeAttr('disabled');
      $('#great_grand_mother3').removeAttr('disabled');
      $('#great_grand_father4').removeAttr('disabled');
      $('#great_grand_mother4').removeAttr('disabled');

      $bgcolor='#fff';
    }
    else
    {
      //$('#removeDamPart').removeAttr('disabled');
      $('#dam').attr('readonly');
      $('#grand_father2').attr('disabled', 'disabled');
      $('#grand_mother2').attr('disabled', 'disabled');
      $('#great_grand_father3').attr('disabled', 'disabled');
      $('#great_grand_mother3').attr('disabled', 'disabled');
      $('#great_grand_father4').attr('disabled', 'disabled');
      $('#great_grand_mother4').attr('disabled', 'disabled');

      $bgcolor='#e4f9d9';
    }

    $('#dam').css("background-color", $bgcolor);
    $('#grand_father2').css("background-color", $bgcolor);
    $('#grand_mother2').css("background-color", $bgcolor);
    $('#great_grand_father3').css("background-color", $bgcolor);
    $('#great_grand_mother3').css("background-color", $bgcolor);
    $('#great_grand_father4').css("background-color", $bgcolor);
    $('#great_grand_mother4').css("background-color", $bgcolor);
  }

  function clearSireTextbox()
  {
    $('#sire_cow_id').val('');
    $('#sire').val('');
    $('#grand_father1').val('');
    $('#grand_mother1').val('');
    $('#great_grand_father1').val('');
    $('#great_grand_mother1').val('');
    $('#great_grand_father2').val('');
    $('#great_grand_mother2').val('');
  }

  function clearDamTextbox()
  {
    $('#dam_cow_id').val('');
    $('#dam').val('');
    $('#grand_father2').val('');
    $('#grand_mother2').val('');
    $('#great_grand_father3').val('');
    $('#great_grand_mother3').val('');
    $('#great_grand_father4').val('');
    $('#great_grand_mother4').val('');
  }

  $("#delCowImage").click(function(){    
      $("#cowimage").attr("src","/storage/cow_images/noimage.jpg");
      $("#cow_image_path").val('noimage.jpg');
  });

  $('#cowimagefile').change(function(){ 
        uploadFile(); 
  });

  function uploadFile(){
    if(uploadCheck()){
      uploadingFile();
    }
  }
  function uploadCheck()
  {
      var upl =  $('#cowimagefile')[0];
      const maxAllowedSize = 5 * 1024 * 1024;

      if(upl.files && upl.files.length == 1)
      {
        if(upl.files[0].size < maxAllowedSize)
        {
          return true;
        }
        alert("File Size > 5M");
      }

      return false;
  };

  function generateTempCowId(input){
    if(input.val() == "")
    {
      input.val(Math.floor((Math.random() * 1000) + 1));
    }
    //console.log(input.val());
  }

  function uploadingFile(){
      $('#uploadimagebtn').hide();
      $('#uploadimagewaitingbtn').show();
      var _token = $('input[name="_token"]').val();
      var $cow_id = $('#cow_id').val();      
  // Create an FormData object 
      var data = new FormData();

  // If you want to add an extra field for the FormData
      data.append("_token", _token);
      data.append("cow_id", $cow_id);
      data.append("cowimagefile", $('#cowimagefile')[0].files[0]);

      $.ajax({
        url:"{{route('uploadcowimage')}}",
        method:'POST',
        enctype: 'multipart/form-data',
        data:data,          
        processData: false,
        contentType: false,
        cache: false,
        success:function(data)
        {
          var timestamp = new Date().getTime();
          $('#cowimage').attr("src",'/storage/cow_images/' + data.cow_image_filename+'?'+timestamp);
          $('#cow_image_path').val(data.cow_image_filename);
        },        
        error: function(jqXHR,textStatus,errorThrown) {
          var err = jQuery.parseJSON(jqXHR.responseText);
          alert(err.errors.cowimagefile);
        },
        complete:function(data)
        {
          $('#uploadimagebtn').show();
          $('#uploadimagewaitingbtn').hide();
        }
      })
  }
  $(document).on("click", "#lastchildlink",function(e){
    $('#childCowListModal').modal('show');
  });

  $("#confirmModalDeleteCowButton").click(function(){
    $('#confirmModalDeleteCowButton').hide();
    $('#confirmModalDeleteCowButtonWaiting').show();
    
    $('#deleteForm').submit();
   
  });
  
</script>
</div>
@endsection
