@extends('layouts.app')
@section('title',' - ข้อมูลวัว')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">
  
@endsection
@section('content')
<!-- Search Criteria Div-->
  <div style="justify-content:space-between;align-items: flex-end;padding:10px">
    <div class="form-group row mb-1">
      <label for="cow_noLabel" class="lcLabel pr-1 col-sm-2 col-form-label">เลขตัววัว/เลขทะเบียน/RFID</label>
      <div class="col-sm-5">
        <input class="form-control pb-1" placeholder="พิมพ์หมายเลขวัว" id="cow_no" name="cow_no" type="text" value="">
      </div>
    </div>
    <div class="form-group row mb-1">      
      <label for="locationLabel" class="lcLabel pr-1 col-sm-2 col-form-label">ที่อยู่วัว</label>
      <div class="col-sm-5">
        <select name="location_id" id='location_id' class='form-control pb-1 col-sm-12'>
          <option value="-1">--ทั้งหมด--</option>
        @foreach ($locations_array as $location)
          <option value="{{ $location->location_id }}">{{$location->location_name }}</option>
        @endforeach
        </select>
      </div>
    </div>
    <div class="form-group row mb-1">      
      <label for="statusLabel" class="lcLabel pr-1 col-sm-2 col-form-label">สถานะ</label>
      <div class="col-sm-5">
        <select name="cow_status_id" id='cow_status_id' class='form-control pb-1 col-sm-12'>
          <option value="-1">--ไม่ระบุ--</option>
        @foreach ($cowstatus_array as $cowstatus)
          <option value="{{ $cowstatus->cow_status_id}}">{{$cowstatus->description}}</option>
        @endforeach
        </select>
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="note" class="lcLabel pr-1 col-sm-2 col-form-label">หมายเหตุ</label>
      <div class="col-sm-5">
        <input class="form-control pb-1" placeholder="" id="note" name="note" type="text" value="">
      </div>
      <div class="d-flex justify-content-start col-sm-5">
        <div class="px-0 searchbutton">
          <button class="btn btn-primary btnSearch" id="btnSearch" type="button">ค้นหา</button>
          <button class="btn btn-primary" type="button" disabled id="btnSearchWaiting" style="display: none">
            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
            Loading...
          </button>
        </div>
        <div class="px-1 searchbutton">
          <button class="btn btn-success" id="btnExport" type="button">Export</button>
        </div>
        <div class="px-0 searchbutton justify-content-end ">
          <button class="btn btn-primary btnAdd" id="btnAdd" type="button">เพิ่มข้อมูลวัว</button>
        </div>
    </div>
  </div>
  <!-- Modal Child Cow List-->
  <div class="modal" id="childCowListModal" tabindex="-1" aria-labelledby="childCowListModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <div class="modal-title" id="childCowListModalLabel">Private Herd No.</div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          <table id="tableChildCowList" class="table table-striped table-sm table-bordered table-hover">
            <thead>
              <tr class="thead-light">
                <th scope="col" class="tableHeader" style="width:60px">หมายเลขลูกวัว</th>
                <th scope="col" class="tableHeader" style="width:35px">เพศ</th>
                <th scope="col" class="tableHeader" style="width:140px">วันเกิด</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table> 
        </div>        
      </div>
    </div>
  </div>
  <!-- End Search Criteria Div-->
  <div id="table_data">
    @include('inc.cowsearchresult')
  </div>
  <script>
    $(document).ready(function(){
      @if (Request::has('cow_no')&&Request::input('cow_no')!='')
      $('#cow_no').val('{{Request::input('cow_no')}}');
        fetch_cow_data();
      @endif

      function create_query()
      {
        var query = new Object();
        query.cow_no = $('#cow_no').val();
        query.location_id = $('#location_id').children("option:selected").val();
        query.cow_status_id = $('#cow_status_id').children("option:selected").val();
        query.note = $('#note').val();

        return JSON.stringify(query);
      }

      $(document).on('click', '.pagination a', function(event){
        event.preventDefault(); 
        var page = $(this).attr('href').split('page=')[1];
        fetch_cow_data(page);
      });

      function fetch_cow_data(page=1)
      { 
        $('#btnSearch').hide();
        $('#btnSearchWaiting').show();

        var _token = $('input[name="_token"]').val();
        var data = new FormData();
        data.append("_token", _token);
        data.append("page", page);
        data.append("query", create_query());

        $.ajax({
          url:"/cows/search?page="+page,
          method:'POST',
          data:data,
          processData: false,
          contentType: false,
          success:function(data)
          {
            $('#table_data').html(data);
          },complete:function(data)
          {
            $('#btnSearch').show();
            $('#btnSearchWaiting').hide();
          }
        });
      }
    
      $(document).on("click", ".btnSearch",function(e){
        e.preventDefault();
        fetch_cow_data(1);
      });

      $(document).on("click", ".btnAdd",function(e){
        e.preventDefault();
        window.location.href="/cows/create";
      });

      $(document).on("click", ".btnEdit",function(e){
        e.preventDefault();
        $cow_id=$(this).attr( "data-id" );
        window.location.href="/cows/"+$cow_id+"/edit";
      });

      $(document).on("click", ".btnShowChildList",function(e){
        e.preventDefault();

        $data_id=$(this).attr( "data-id" );
        myArray=$data_id.split("|");
        $cow_id=myArray[0];
        $private_herd_no=myArray[1];
        showChildCowListModal($cow_id,$private_herd_no);
      });

      function showChildCowListModal(cow_id,private_herd_no)
      {
        var childCowListHTML;

        var _token = $('input[name="_token"]').val();
        var data = new FormData();
        data.append("_token", _token);
        data.append("cow_id", cow_id);

        $.ajax({
          url:"/cows/getchildcowfromparentid",
          method:'POST',
          data:data,
          processData: false,
          contentType: false,
          async: false,
          success:function(data)
          {
            var output=JSON.parse(data);
            childCowListHTML = output.childCowHTML;
          }
        });

        $('#childCowListModalLabel').text('หมายเลขแม่/พ่อ - '+private_herd_no);

        $('#tableChildCowList tbody').html(childCowListHTML);

        $('#childCowListModal').modal('show');
      }

      $(document).on("click", ".btnPedigree",function(e){
        e.preventDefault();
        $cow_id=$(this).attr( "data-id" );
        window.open("/cows/compactview/"+$cow_id);
      });

      $("#btnExport").click(function(){
        window.open('/cows/exportcowstocsv', '_blank');
      });

      $('#cow_no').keypress(function(event){
        var keycode = (event.keyCode ? event.keyCode : event.which);
        if(keycode == '13'){
          fetch_cow_data(1);
        }
      });
    });
  </script>
</div>
@endsection