@extends('layouts.app')
@section('title',' - ข้อมูลลูกค้า')
@section('add_to_head')
<link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">
  
@endsection
@section('content')
<div class="py-2">
<form method="POST" action="{{action('CustomersController@store')}}" accept-charset="UTF-8" id="saveForm">
  @csrf
  <input id="customer_id" name="customer_id" type="hidden" value="{{$customer_id??0}}">
  <div class="form-group row mt-2">
    <label for="customer_nameLabel" class="col-sm-2 lcLabel col-form-label">ชื่อลูกค้า</label>
    <div class="col-sm-5">
      <input class="form-control" id="customer_name" placeholder="ชื่อลูกค้า" name="customer_name" type="text" value="{{$customerData->customer_name??''}}">
    </div>
  </div>
  <div class="form-group row ">
    <label for="addressLabel" class="col-sm-2 lcLabel col-form-label">ที่อยู่</label>
    <div class="col-sm-5">
      <input class="form-control" id="address1" placeholder="ที่อยู่" name="address1" type="text" value="{{$customerData->address1??''}}">
    </div>
  </div>
  <div class="form-group row ">
    <label for="provinceLabel" class="col-sm-2 lcLabel col-form-label">จังหวัด</label>
    <div class="col-sm-5">
      <select name="province_id" id="province_id" class='form-control'>
        <option value="0">--- Select ---</option>
        @if (isset($provinceData) and count($provinceData)>0)
          @foreach($provinceData as $province)
            <option value="{{$province->province_id}}">{{$province->name_th}}</option>
          @endforeach
        @endif
      </select>
    </div>
  </div>
  <div class="form-group row ">
    <label for="phone_noLabel" class="col-sm-2 lcLabel col-form-label">เบอร์โทรศัพท์</label>
    <div class="col-sm-5">
      <input class="form-control" id="phone_no" placeholder="เบอร์โทรศัพท์" name="phone_no" type="text" value="{{$customerData->phone_no??''}}">
    </div>
  </div>
  <div class="form-group row ">
    <label for="noteLabel" class="col-sm-2 lcLabel col-form-label">หมายเหตุ</label>
    <div class="col-sm-5">
      <input class="form-control" id="note" placeholder="หมายเหตุ" name="note" type="text" value="{{$customerData->note??''}}">
    </div>
  </div>
  <div class="form-group row pt-2 mt-2">
    <div class="col-sm-2"></div>
    <div class="col-sm-5">
      <!-- Button trigger modal -->
      <button id="saveButton" type="button" class="btn btn-primary" >บันทึก</button>
      <button id="backButton" type="button" class="btn btn-outline-secondary" >ยกเลิก</button>
    </div>
  </div>
  
{!! Form::close() !!}
</div>
<div id="table_data">
@if (isset($data) and $data->count() >0)
  <table id="tableResult" class="table table-striped table-sm table-bordered table-hover">
    <thead>
      <tr class="thead-light">
        <th scope="col" class="tableHeader"style="width:100px">หมายเลขวัว</th>
        <th scope="col" class="tableHeader" style="width:50px">พันธุ์</th>
        <th scope="col" class="tableHeader" style="width:50px">เพศ</th>
        <th scope="col" class="tableHeader" style="width:50px">สถานะขาย</th>
        <th scope="col" class="tableHeader" style="width:50px">วันที่จอง</th>
        <th scope="col" class="tableHeader" style="width:50px">วันที่จ่ายเงิน</th>
        <th scope="col" class="tableHeader" style="width:50px">วันที่ส่งวัว</th>
        <th scope="col" class="tableHeader" style="max-width:40px; width: 20px">ใบประวัติ</th>
      </tr>
    </thead>
    <tbody>

      @foreach($data as $row)
        <tr>
          <td class="tableDetail">
            <a target="_blank" href="../../cows/{{ $row->cow_id }}/edit">{{ $row->private_herd_no }}</a>
          </td>
          <td class="tableDetail">{{ $row->breed_text }}</td>
          <td class="tableDetail">{{ $row->sex_text }}</td>
          <td class="tableDetail">
            <a target="_blank" href="../../cows/{{ $row->cow_id }}/cowsale">{{ $row->description }}</a></td>
          <td class="tableDetail">{{ ConvertFromMYSQLDateToThai($row->last_sale_date) }}</td>
          <td class="tableDetail">{{ ConvertFromMYSQLDateToThai($row->last_sale_date) }}</td>
          <td class="tableDetail">{{ ConvertFromMYSQLDateToThai($row->last_sale_date) }}</td>
          <td class="tableDetail">
            <a class="btnPedigree" style="cursor:pointer" target="_blank" href="../../pdf/cowpedigreepdf/{{ $row->cow_id }}">
              <i class="fas fa-award"></i>
            </a>
          </td>
        </tr>
      @endforeach
    </tbody>
  </table>
@endif
</div>
<!-- Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmModalLabel">บันทึกข้อมูล</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ต้องการบันทึกข้อมูลลูกค้า
      </div>
      <div class="modal-footer">
        <button id="confirmModalSaveButton" type="button" class="btn btn-primary">บันทึกข้อมูล</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        
      </div>
    </div>
  </div>
</div>

<script>

$(document).ready(function(){
  $('#province_id').val({{$customerData->province_id}});

    $('#saveButton').click(function(){            
        if(checkValidation())
        {
            $("#confirmModal").modal('show');
        }
        else
            alert("ไม่ได้กรอกข้อมูล ชื่อลูกค้า");
    });

    $("#confirmModalSaveButton").click(function(){
        $('#saveForm').submit();
    });

    function checkValidation(){
        var isValid = true;
        $('#customer_name').val($('#customer_name').val().trim());
        $('#address1').val($('#address1').val().trim());
        $('#phone_no').val($('#phone_no').val().trim());
        $('#note').val($('#note').val().trim());

        if($('#customer_name').val() == ''){
            isValid = false;
        }
        return isValid;
    }
    $(document).on("click", "#backButton",function(e){
      e.preventDefault();
      window.location.href="/customers";
    });
});    
</script>
</div>
@endsection