@extends('layouts.app')
@section('title',' - ข้อมูลลูกค้า')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">
  
@endsection
@section('content')
<!-- Search Criteria Div-->
  <div style="justify-content:space-between;align-items: flex-end;padding:10px">
    <div class="form-group row mb-1">
      <label for="customer_nameLabel" class="lcLabel pr-1 col-sm-2 col-form-label">ชื่อลูกค้า</label>
      <div class="col-sm-5">
        <input class="form-control pb-1" placeholder="ชื่อลูกค้า" id="customer_name" name="customer_name" type="text" value="">
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="private_herd_noLabel" class="lcLabel pr-1 col-sm-2 col-form-label">เลขตัววัว</label>
      <div class="col-sm-5">
        <input class="form-control pb-1" placeholder="เลขตัววัว" id="private_herd_no" name="private_herd_no" type="text" value="">
      </div>
    </div>
    <div class="form-group row mb-1">
      <label for="note" class="lcLabel pr-1 col-sm-2 col-form-label">หมายเหตุ</label>
      <div class="col-sm-5">
        <input class="form-control pb-1" placeholder="" id="note" name="note" type="text" value="">
      </div>
      <div class="d-flex justify-content-start col-sm-5">
        <div class="px-0 searchbutton">
          <button class="btn btn-primary btnSearch" id="btnSearch" type="button">ค้นหา</button>
        </div>        
        <div class="px-1 searchbutton justify-content-end ">
          <button class="btn btn-primary btnAdd" id="btnAdd" type="button">เพิ่มลูกค้า</button>
        </div>
    </div>
  </div>
  <!-- End Search Criteria Div-->
  <div class="mt-3" id="table_data">
    @include('inc.customersearchresult')
  </div>
  <script>
    $(document).ready(function(){
   
      function create_query()
      {
        var query = new Object();
        query.customer_name = $('#customer_name').val();
        query.note = $('#note').val();
        query.private_herd_no = $('#private_herd_no').val();
        return JSON.stringify(query);
      }

      $(document).on('click', '.pagination a', function(event){
        event.preventDefault(); 
        var page = $(this).attr('href').split('page=')[1];
        fetch_cow_data(page);
      });

      function fetch_cow_data(page=1)
      { 
        var _token = $('input[name="_token"]').val();
        var data = new FormData();
        data.append("_token", _token);
        data.append("page", page);
        data.append("query", create_query());

        $.ajax({
          url:"/customers/search?page="+page,
          method:'POST',
          data:data,
          processData: false,
          contentType: false,
          success:function(data)
          {
            $('#table_data').html(data);
          }
        });
      }
    
      $(document).on("click", ".btnSearch",function(e){
        e.preventDefault();
        fetch_cow_data(1);
      });

      $(document).on("click", ".btnAdd",function(e){
        e.preventDefault();
        window.location.href="/customers/create";
      });

      $(document).on("click", ".btnEdit",function(e){
        e.preventDefault();
        $data_id=$(this).attr( "data-id" );
        window.location.href="/customers/"+$data_id+"/edit";
      });
    });
  </script>
</div>
@endsection