@extends('layouts.app')
@section('add_to_head')
  <link href="{{asset('css/dashboard_styles.css')}}" rel="stylesheet" />        
@endsection
@section('add_to_body')
  <!-- Core theme JS-->
  <script src="{{asset('js/dashboard_scripts.js')}}"></script>  
@endsection
@section('content')
  <div class="mt-2">
    <nav>
      <div class="nav nav-pills mb-3" id="nav-tab" role="tablist">
        <button class="nav-link active" id="nav-booked-tab" data-bs-toggle="tab" data-bs-target="#nav-booked" type="button" role="tab" aria-controls="nav-booked" aria-selected="true" data-sale-status="1">จอง</button>
        <button class="nav-link" id="nav-paid-tab" data-bs-toggle="tab" data-bs-target="#nav-paid" type="button" role="tab" aria-controls="nav-paid" aria-selected="false" data-sale-status="2">จ่ายเงินแล้ว</button>
        <button class="nav-link" id="nav-delivery-tab" data-bs-toggle="tab" data-bs-target="#nav-delivery" type="button" role="tab" aria-controls="nav-delivery" aria-selected="false" data-sale-status="3">ส่งวัวแล้ว</button>
      </div>
    </nav>
    <div class="tab-content" id="nav-tabContent">
      <div class="tab-pane fade show active" id="nav-booked" role="tabpanel" aria-labelledby="nav-booked-tab">
        <table id="tableCowData" class="table table-sm table-bordered table-hover mt-2">
          <thead>
            <tr class="thead-light">
              <th scope="col" class="tableHeader"style="width:100px">วันที่จอง</th>  
              <th scope="col" class="tableHeader"style="width:100px">เลขบนตัว</th>
              <th scope="col" class="tableHeader"style="width:100px">ชื่อลูกค้า</th>
              <th scope="col" class="tableHeader"style="width:100px">จังหวัด</th>
              <th scope="col" class="tableHeader"style="width:100px">เบอร์โทรศัพท์</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
      <div class="tab-pane fade" id="nav-paid" role="tabpanel" aria-labelledby="nav-paid-tab">
      <table id="tableCowData" class="table table-sm table-bordered table-hover mt-2">
          <thead>
            <tr class="thead-light">
              <th scope="col" class="tableHeader"style="width:100px">วันที่จอง</th>  
              <th scope="col" class="tableHeader"style="width:100px">เลขบนตัว</th>
              <th scope="col" class="tableHeader"style="width:100px">ชื่อลูกค้า</th>
              <th scope="col" class="tableHeader"style="width:100px">จังหวัด</th>
              <th scope="col" class="tableHeader"style="width:100px">เบอร์โทรศัพท์</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
      <div class="tab-pane fade" id="nav-delivery" role="tabpanel" aria-labelledby="nav-delivery-tab">
      <table id="tableCowData" class="table table-sm table-bordered table-hover mt-2">
        <thead>
          <tr class="thead-light">
            <th scope="col" class="tableHeader"style="width:100px">วันที่จอง</th>  
            <th scope="col" class="tableHeader"style="width:100px">เลขบนตัว</th>
            <th scope="col" class="tableHeader"style="width:100px">ชื่อลูกค้า</th>
            <th scope="col" class="tableHeader"style="width:100px">จังหวัด</th>
            <th scope="col" class="tableHeader"style="width:100px">เบอร์โทรศัพท์</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
      </div>
    </div>
  </div>
  <div id="spinnerLoading" style="display: none;">
  <div class="spinner-border" style="position:absolute;left:50%">
    <span class="visually-hidden">Loading...</span>
  </div>
  </div>
  <script>
    $(document).ready(function(){
      
      getCowDataByStatus(1,'#nav-booked');

      $(document).on('show.bs.tab','[data-bs-toggle="tab"]',function(event){
        getCowDataByStatus(event.target.getAttribute("data-sale-status"),event.target.getAttribute("data-bs-target"));
      });      

      function getCowDataByStatus(status_id,target_tab){
        try{
          var data = new FormData();
          var _token = $('input[name="_token"]').val();
          data.append("_token", _token);
          data.append("sale_status_id", status_id);
          $(target_tab +' #tableCowData tbody').html('');
          $('#spinnerLoading').show();
          $.ajax({
              url:"{{route('cowsales.getcowbystatus')}}",
              method:'POST',
              data:data,
              processData: false,
              contentType: false,
              success:function(data)
              {
                //console.log(data);
                data=data.replace(/null/i, "\"\"");
                var output=JSON.parse(data);
                cows = output.cows;
                $output='';
                $backgroundColor="";
                if(cows.length >0){
                  for(var i =0;i < cows.length;i++)
                  {                    
                    if(cows[i].duration > 7){
                      $output += "<tr class='trexpire' data-id='"+cows[i].cow_id+"'>";
                    }
                    else
                    {
                      $output += "<tr data-id='"+cows[i].cow_id+"'>"
                    }
                    $output += "<td class='tableDetail'>"+cows[i].last_sale_date+"</td>"+"<td class='tableDetail'><a href='/cows/"+cows[i].cow_id+"/edit'>"+ cows[i].private_herd_no+"</td>"+"<td class='tableDetail'><a href='/customers/"+cows[i].customer_id +"/edit'>"+ cows[i].customer_name+"</a></td>"+"<td class='tableDetail'>"+ cows[i].name_th+"</td>"+"<td class='tableDetail'>"+ cows[i].phone_no+"</td></tr>";
                  }
                  $(target_tab +' #tableCowData  tbody').html($output);
                }
              },
              complete:function(data){
                $('#spinnerLoading').hide();
              },
            });
        }
        catch($err){
          $('#spinnerLoading').hide();
        };
      }
    });
  </script>
</div>

@endsection
