<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
 
        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{config('app.name','Cow Management')}}</title>
        <link rel='stylesheet' href="{{asset('css/app.css')}}">
        <link rel='stylesheet' href="{{asset('css/lc_app.css')}}">

        <link href="{{asset('vendor/fontawesome-free/css/solid.min.css') }}" rel="stylesheet">
        <link href="{{asset('vendor/fontawesome-free/css/fontawesome.min.css') }}" rel="stylesheet">
        <script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
        <script src="{{asset('js/popper.min.js')}}"></script>
        <script src="{{asset('js/bootstrap.min.js')}}"></script>
        <script src="{{asset('js/lc_app.js')}}"></script>
    @if($useDatePicker??false)
        <link rel="stylesheet" href="{{asset('css/jquery-ui.css')}}">
        <script src="{{asset('js/jquery-ui-1.11.4.custom.js')}}"></script>
        <link rel="stylesheet" href="{{asset('css/lc_datepicker.css')}}">
        <script src="{{asset('js/lc_datepicker.js')}}"></script>
    @endif
    @if($useTreeView??false)
        <link rel="stylesheet" href="{{asset('css/lc_cowtree.css')}}">
        <script src="{{asset('js/lc_cowtree.js')}}"></script>
    @endif
    </head>
    <body>
        <!-- Page Wrapper -->
        <div id="wrapper">
            @include('inc.sidebar')
            <!-- Content Wrapper -->
            <div id="content-wrapper" class="d-flex flex-column">
                <!-- Main Content -->
                <div id="content">
                    @include('inc.topbar')
                    <!-- Begin Page Content -->
                    <div class="container-fluid content-bg pb-2">
                        @include('inc.messages')
                        @yield('content')
                    </div>
                    <!-- End Page Content -->
                </div>
                <!-- End Main Content -->
            </div>
            <!-- End Content Wrapper -->
        </div>
        <!-- End Page Wrapper -->
        
        
    </body>
</html>
