<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
 
        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{config('app.name','Cow Management')}}</title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="{{asset('images/favicon.ico')}}" />
        <!-- Font Awesome icons (free version)-->
        <script src="https://use.fontawesome.com/releases/v5.15.3/js/all.js" crossorigin="anonymous"></script>
        <!-- Google fonts-->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Prompt:wght@400;700&display=swap" rel="stylesheet"> 
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet" />
        <link rel='stylesheet' href="{{asset('css/lc_app.css')}}">
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="{{asset('css/dashboard_styles.css')}}" rel="stylesheet" />
              
        <script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
        <script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
        
        <script src="{{asset('js/lc_app.js')}}"></script>
        <!-- Core theme JS-->
        <script src="{{asset('js/dashboard_scripts.js')}}"></script>  

        @if($useDatePicker??false)
            <link rel="stylesheet" href="{{asset('css/jquery-ui.css')}}">
            <script src="{{asset('js/jquery-ui-1.11.4.custom.js')}}"></script>
            <link rel="stylesheet" href="{{asset('css/lc_datepicker.css')}}">
            <script src="{{asset('js/lc_datepicker.js')}}"></script>
        @endif
        
        @if($useTreeView??false)
            <link rel="stylesheet" href="{{asset('css/lc_cowtree.css')}}">
            <script src="{{asset('js/lc_cowtree.js')}}"></script>
        @endif
    </head>
    <body>
      @include('inc.topbar')
      <!-- Begin Page Content -->
      <div class="container-fluid">
        @include('inc.messages')
        @yield('content')
      </div>
      <!-- End Page Content -->      

    </body>
</html>