@extends('layouts.authentication')

@section('content')
<div class="limiter">
  <div class="container-login100">
    <div class="wrap-login100">
      <div class="login100-form-title" style="background-image: url(images/auth_bg.jpg);">
        <span class="login100-form-title-1">
          Sign In
        </span>
      </div>

      <form class="login100-form validate-form" method="POST" action="{{ route('login') }}">
        @csrf
        <div class="wrap-input100 validate-input mb-4" data-validate="Username is required">
          <span class="label-input100">Username</span>
          <input id="username" class="input100 @error('username') is-invalid @enderror" type="text" name="username" placeholder="Enter username" value="{{ old('username') }}" required autocomplete="username" autofocus>
          <span class="focus-input100"></span>
          @error('username')
            <span class="invalid-feedback" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror			
        </div>

        <div class="wrap-input100 validate-input mb-3" data-validate = "Password is required">
          <span class="label-input100">Password</span>
          <input id="password" class="input100 @error('password') is-invalid @enderror" type="password" name="password" placeholder="Enter password" required autocomplete="current-password">
          <span class="focus-input100"></span>
          @error('password')
              <span class="invalid-feedback" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
          @enderror
        </div>

        <div class="container-login100-form-btn">
          <button type="submit" class="login100-form-btn">
            Login
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
