@extends('layouts.authentication')
@section('content')
<div class="limiter">
  <div class="container-login100">
    <div class="wrap-login100">
      <div class="login100-form-title" style="background-image: url(images/auth_bg.jpg);">
        <span class="login100-form-title-1">
          Create User
        </span>
      </div>

      <form class="login100-form validate-form" method="POST" action="{{ route('register') }}">
        @csrf
        <div class="wrap-input100 validate-input m-b-26" data-validate="Username is required">
          <span class="label-input100">Username</span>
          <input id="username" class="input100 @error('username') is-invalid @enderror" type="text" name="username" placeholder="Enter username" value="{{ old('username') }}" required autofocus>
          <span class="focus-input100"></span>
          @error('username')
            <span class="invalid-feedback" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror			
        </div>

        <div class="wrap-input100 validate-input m-b-18" data-validate = "Password is required">
          <span class="label-input100">Password</span>
          <input id="password" class="input100 @error('password') is-invalid @enderror" type="password" name="password" placeholder="Enter password" required >
          <span class="focus-input100"></span>
          @error('password')
              <span class="invalid-feedback" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
          @enderror
        </div>

        <div class="wrap-input100 validate-input m-b-18" data-validate = "Password Confirm">
          <span class="label-input100">Password Confirm</span>
          <input id="password_confirmation" class="input100 @error('password_confirmation') is-invalid @enderror" type="password" name="password_confirmation" placeholder="Enter password" required >
          <span class="focus-input100"></span>
          @error('password_confirmation')
              <span class="invalid-feedback" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
          @enderror
        </div>

        <div class="wrap-input100 validate-input m-b-26" data-validate="Staff name is required">
          <span class="label-input100">Staff Name</span>
          <input id="name" class="input100 @error('name') is-invalid @enderror" type="text" name="name" placeholder="Enter name" value="{{ old('name') }}" required autocomplete="name" autofocus>
          <span class="focus-input100"></span>
          @error('name')
            <span class="invalid-feedback" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror			
        </div>
        
        <div class="wrap-input100 validate-input m-b-26" data-validate="Role is required">
          <span class="label-input100">Role</span>
          <select id="role" name="role" class="input-select100 @error('role') is-invalid @enderror" >
            <option value="admin">Admin</option>
            <option selected value="staff">Staff</option>
          </select>
          <span class="focus-input100"></span>
          @error('role')
            <span class="invalid-feedback" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror			
        </div>

        <div class="container-login100-form-btn">
          <button type="submit" class="login100-form-btn">
            Create User
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
