@extends('layouts.app')
@section('title',' - เพิ่มที่อยู่วัว')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">  
@endsection
@section('content')
<form method="POST" action="{{action('LocationsController@store')}}" accept-charset="UTF-8" id="saveForm">
  @csrf
  <div class="form-group row mt-3">
    <label for="location_nameLabel" class="col-sm-1 col-form-label text-end">ที่อยู่</label>
    <div class="col-sm-5">
      <input class="form-control" id="location_name" placeholder="พิมพ์ที่อยู่" name="location_name" type="text" value="">
    </div>
  </div>
  <div class="form-group row mt-2">
    <label for="isActiveLabel" class="col-sm-1 col-form-label text-end">ใช้งาน</label>
    <div class="col-sm-5">
      <input class="align-bottom" checked="checked" name="isactive" type="checkbox" value="1">
    </div>
  </div>
  <div class="form-group row mt-4">
    <div class="col-sm-1"></div>
    <div class="col-sm-5 d-flex justify-content-start">
      <!-- Button trigger modal -->
      <button id="saveButton" type="button" class="btn btn-primary me-2" >
      บันทึก</button>
      <button class="btn btn-outline-secondary" onclick="history.back(-1)" type="button">ยกเลิก</button> 
    </div>
  </div>
</form>

<!-- Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmModalLabel">บันทึกข้อมูล</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ต้องการบันทึกข้อมูลที่อยู่วัว
      </div>
      <div class="modal-footer">
        <button id="confirmModalSaveButton" type="button" class="btn btn-primary">บันทึกข้อมูล</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        
      </div>
    </div>
  </div>
</div>

<script>

    $(document).ready(function(){        
        $('#saveButton').click(function(e){
            if(checkValidation())
            {
                $("#confirmModal").modal('show');
            }
            else
            {
                alert("ไม่ได้กรอกข้อมูล ที่อยู่");
            }
        });

        $("#confirmModalSaveButton").click(function(){
            $('#saveForm').submit();
        });

        function checkValidation(){
            var isValid = true;
            $('#location_name').val($('#location_name').val().trim());

            if($('#location_name').val() == ''){
                isValid = false;
            }
            return isValid;
        }
    });    
</script>
</div>
@endsection