@extends('layouts.app')
@section('title',' - ที่อยู่วัว')
@section('add_to_head')
        <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">
        <link rel='stylesheet' href="{{asset('css/lc_location.css')}}">
@endsection
@section('content')
<div style="display:flex;justify-content:space-between;align-items: flex-start;padding:5px">
        <a class="btn btn-primary" id ="btnAdd" name="btnAdd" href="./locations/create">เพิ่มที่อยู่วัว</a>
</div>
@if(count($locations)>0)
<table id="tableLocation" class="table table-striped table-sm table-bordered table-hover">
        <thead>
                <tr class="thead-light">
                <th scope="col">ที่อยู่</th>
                <th scope="col" style="width:50px">ใช้งาน</th>
                <th scope="col" style="width:50px"></th>
                <th scope="col" style="width:50px"></th>
        </tr>
        </thead>
        <tbody>
                @foreach ($locations as $location)
                <tr>
                <td style="text-align: left;">
                        <a id="location{{$location->location_id}}" href="./locations/{{$location->location_id}}/edit">
                                {{$location->location_name}}
                        </a>
                </td>
                <td style="text-align: center;">
                        @if($location->is_active =='1')
                                <i class="fas fa-check"></i>
                        @endif
                </td>
                <td>
                        <a href="./locations/{{$location->location_id}}/edit">
                                <i class="fas fa-edit"></i>
                        </a>
                </td>
                <td>
                        <a data-toggle="modal" href="#myModal" data-id="{{$location->location_id}}" class="open-DelLocationDialog">
                                <i class="fas fa-trash-alt"></i>
                        </a>
                </td>
                </tr>
                @endforeach
        </tbody>
</table>
@else
<p>No Locations found</p>
@endif
<!-- Modal -->
<div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                        <div class="modal-header">
                                <h4 class="modal-title">ลบที่อยู่วัว</h4>
                        </div>
                        <div class="modal-body">
                                
                                <div id="delLocationDialogText"></div>
                        </div>
                        <div class="modal-footer">
                                <form method="POST" action="{{action('LocationsController@delete')}}" accept-charset="UTF-8">
                                        @csrf
                                        <input name="location_id" type="hidden">
                                        
                                        <input class="btn btn-primary" type="submit" value="ลบที่อยู่วัว">
                                        <button class="btn btn-light" data-dismiss="modal" type="button">ยกเลิก</button>
                                </form>
                        </div>
                </div>
        </div>
</div>

@endsection