<html lang="th" dir="ltr">
  <head>
    <title></title>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style type="text/css" media="all">
      @font-face {
          font-family: 'Prompt';
          font-style: normal;
          font-weight: normal;
          src: url("{{ public_path('fonts/prompt/Prompt-Regular.ttf') }}") format('truetype');
      }
      @font-face {
          font-family: 'Prompt';
          font-style: normal;
          font-weight: bold;
          src: url("{{ public_path('fonts/prompt/Prompt-Bold.ttf') }}") format('truetype');
      }
      @font-face {
          font-family: 'Prompt';
          font-style: italic;
          font-weight: normal;
          src: url("{{ public_path('fonts/prompt/Prompt-Italic.ttf') }}") format('truetype');
      }
      @font-face {
          font-family: 'Prompt';
          font-style: italic;
          font-weight: bold;
          src: url("{{ public_path('fonts/prompt/Prompt-BoldItalic.ttf') }}") format('truetype');
      }

      body{
        font-family: "Prompt";
        line-height: 1.6;
        width: 1200px;
        height: 848px;
        box-sizing: border-box;
        border: 1px solid black;
      }
      .content{
        width: auto;
        margin:50px 10px 30px 10px;
        display: block;
      }
      .header{
        padding-left: 10px;
        padding-right: 10px;
      }
      .row {
        display: flex;
        flex-wrap: wrap;
        margin-top:15px;
      }
      .labelText{
        font-weight: bold;
        font-size: 16px;
        flex: 0 0 11%;
        width:11%;
        position: relative;
        display: inline-block;
        text-align: right;
        padding-left: 5px;
        padding-right: 5px;
        padding-top: 3px;
      }
      .dataText{
        font-size: 18px;
        width:20%;
        padding-left: 5px;
        padding-right: 5px;
        position: relative;
        border-bottom: 1px solid #495057;
      }

      #tree-view-wrapper {
        border: 1px solid #dee2e6;
        position: relative;
        width: 1130px;
        margin-top: 20px;
        padding: 5px 20px 20px 20px;
      }
      div.root {
        position: relative;
        min-height: 35px;
        margin: 5px 0px;
      }

      .branch {
        position: relative;
        margin-left: 394px;
      }
      .branch:before {
        content: "";
        width: 25px;
        position: absolute;
        left: -50px;
        top: 50%;
        margin-top: -2px;
      }
      
      .branch.dam-part:before {    
        border-top: 2px solid #7cae00;
      }

      .branch.sire-part:before {    
        border-top: 2px solid #f7941e;
      }

      .entry {
        position: relative;
        min-height: 35px;
      }
      .entry:before {
        content: "";
        height: 100%;
        position: absolute;
        left: -25px;
      }

      .entry.dam-part:before {    
        border-left: 2px solid #7cae00;
      }
      .entry.sire-part:before {    
        border-left: 2px solid #f7941e;
      }
      .entry:after {
        content: "";
        width: 25px;    
        position: absolute;
        left: -25px;
        top: 50%;
        margin-top: 1px;
      }
      .entry.dam-part:after {    
        border-top: 2px solid #7cae00;
      }
      .entry.sire-part:after {    
        border-top: 2px solid #f7941e;
      }

      .entry:first-child:before {
        width: 50px;
        height: 50%;
        top: 50%;
        margin-top: 2px;
        border-radius: 5px 0 0 0;
      }
      .entry:first-child:after {
        height: 50px;
        border-radius: 5px 0 0 0;
      }
      .entry:last-child:before {
        width: 50px;
        height: 50%;
        border-radius: 0 0 0 5px;
      }
      .entry:last-child:after {
        height: 25px;
        border-top: none!important;
        border-radius: 0 0 0 5px;
        margin-top: -25px;
      }

      .entry.dam-part:last-child:after {    
        border-bottom: 2px solid #7cae00;
      }
      .entry.sire-part:last-child:after {    
        border-bottom: 2px solid #f7941e;
      }
      .entry.sole:before {
        display: none;
      }
      .entry.sole:after {
        width: 25px;
        height: 0;
        margin-top: 1px;
        border-radius: 0;
      }

      .input-cow-tree {
        display: block;
        width: 330px;
        padding: 5px;
        line-height: 20px;
        text-align: left;
        border-radius: 5px;
        position: absolute;
        left: 0px;
        top: 50%;
        margin-top: -13px;
        height: 20px;
        border-width: 2px;
        border-style: solid;
        outline: none;
        font-size:18px;
        font-weight: bold;
      }

      .input-cow-tree.dam-part {    
        border-color:#7cae00;
        background-color:#fff;
      }

      .input-cow-tree.sire-part {
        border-color:#f7941e;
        background-color:#fff;
      }
      .input-cow-tree.root
      {
        border-radius: 5px;
        border-width: 2px;
      }
      #divDam
      {
        margin-top:20px;
      }
    </style>
  </head>
  <body>
    <?php $cowData=json_decode($cowData); ?>
    <div class="content">
      <div class="row Header">
        <h2>ฟาร์มลุงเชาวน์(Loong Chow Farm)</h2>
      </div>

      <div class="row">
        <label class="labelText">ชื่อโค</label>
        <label class="dataText">{{$cowData->cow_name}}</label>
        <label class="labelText">ทะเบียนโค</label>
        <label class="dataText">{{$cowData->regisno1}}</label>
        <label class="labelText">หมายเลขตัวโค</label>
        <label class="dataText">{{$cowData->private_herd_no}}</label>
      </div>
      <div class="row">
        <label class="labelText">วันเกิด</label>
        <label class="dataText">{{$cowData->birth_date}}</label>
        <label class="labelText">เพศ</label>
        <label class="dataText">{{$cowData->sex}}</label>
        <label class="labelText">พันธุ์โค</label>
        <label class="dataText">{{$cowData->breed}}</label>
      </div>

      <div id="tree-view-wrapper">
        <label style="position: absolute;left:20px;top:40px;font-weight: bold;font-size:20px;">Sire</label>
        <label style="position: absolute;left:20px;top:200px;font-weight: bold;font-size:20px;">Dam</label>
        
        <div id="divSire" class="root">
          <label class="input-cow-tree sire-part root">{{$cowData->sire}}</label>
          <div class="branch lv1 sire-part">
            <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->grand_father1}}</label>
              <div class="branch lv2 sire-part">
                <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->great_grand_father1}}</label></div>
                <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->great_grand_mother1}}</label></div>
              </div>
            </div>
            <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->grand_mother1}}</label>
              <div class="branch lv2 sire-part">
                <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->great_grand_father2}}</label></div>
                <div class="entry sire-part"><label class="input-cow-tree sire-part">{{$cowData->great_grand_mother2}}</label></div>
              </div>
            </div>  
          </div>
        </div>
        <div id="divDam" class="root">
          <label class="input-cow-tree dam-part root">{{$cowData->Dam}}</label>         
          <div class="branch lv1 dam-part">
            <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->grand_father2}}</label>
              <div class="branch lv2 dam-part">
                <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->great_grand_father3}}</label></div>
                <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->great_grand_mother3}}</label></div>
              </div>
            </div>
            <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->grand_mother2}}</label>
              <div class="branch lv2 dam-part">
                <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->great_grand_father4}}</label></div>
                <div class="entry dam-part"><label class="input-cow-tree dam-part">{{$cowData->great_grand_mother4}}</label></div>
              </div>
            </div>
          </div>
        </div>
    </div>
    </div>
  </body>
</html>