@extends('layouts.app')
@section('title',' - เปลี่ยน password')
@section('add_to_head')
  <link rel='stylesheet' href="{{asset('css/lc_cow.css')}}">  
@endsection
@section('content')
<form method="POST" action="{{route('users.changepassword')}}" accept-charset="UTF-8" id="saveForm">
  {{ csrf_field() }}
  <input type="hidden" name="user_id" value="{{Auth::id()}}">
  <div class="form-group row mt-3">
    <label class="col-sm-2 col-form-label text-end">Username</label>
    <label class="col-sm-3 col-form-label text-start" style="font-size: 120%">{{Auth::user()->username}}</label>
  </div>
  <div class="form-group row">
    <label class="col-sm-2 col-form-label text-end">New Password</label>
    <div class="col-sm-3">
      <input id="password" name="password" type="password" class="form-control" placeholder="New Password">
    </div>
    <div class="col-sm-1 ms-0 ps-0 mt-2">
      <i class="fas fa-eye-slash" id="showPassword"></i>
    </div>
  </div>
  <div class="form-group row mt-2">
    <label class="col-sm-2 col-form-label text-end">Confirm New Password</label>
    <div class="col-sm-3">
      <input id="password_confirmation" name="password_confirmation" type="password" class="form-control" placeholder="Confirm New Password">
    </div>
    <div class="col-sm-4 ms-0 ps-0 mt-2">
      <label id="error_message" class="text-danger"></label>
    </div>
  </div>
  <!-- Button trigger modal -->
  <div class="form-group row mt-3">
    <div class="col-sm-2"></div>
    <div class="col-sm-3 d-flex justify-content-start">
      <button id="saveButton" type="button" class="btn btn-primary me-2" >บันทึก</button>
      <button class="btn btn-outline-secondary" onclick="history.back(-1)" type="button">ยกเลิก</button>
    </div>
  </div>
</form>
<!-- Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmModalLabel">บันทึกข้อมูล</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ต้องการบันทึก Password
      </div>
      <div class="modal-footer">
        <button id="confirmModalSaveButton" type="button" class="btn btn-primary">บันทึก</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        
      </div>
    </div>
  </div>
</div>

<script>

    $(document).ready(function(){        
        $('#saveButton').click(function(e){
          $('#error_message').text('');
            if(checkValidation())
            {
              $("#confirmModal").modal('show');
            }
            else
            {
              $('#error_message').text("Passwords do not match");
            }
        });

        $("#confirmModalSaveButton").click(function(){
            $('#saveForm').submit();
        });

        function checkValidation(){
            var isValid = true;
            if($('#password').val() != $('#password_confirmation').val()){
                isValid = false;
            }
            return isValid;
        }
        $(document).on("click", "#showPassword",function(e){
          e.preventDefault();       
          if($("#password").attr("type")=="password")
          {
            $("#password").attr("type","text");
            $("#password_confirmation").attr("type","text");
            $("#showPassword").removeClass("fas fa-eye-slash");
            $("#showPassword").addClass("fas fa-eye");
          }
          else{
            $("#password").attr("type","password");
            $("#password_confirmation").attr("type","password");
            $("#showPassword").removeClass("fas fa-eye");
            $("#showPassword").addClass("fas fa-eye-slash");
          }
            
        });
    });    
</script>
</div>
@endsection