<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/login', 'lcauth\LCAuthController@showLoginForm');
Route::post('/login', 'lcauth\LCAuthController@login')->name('login');
Route::post('/logout', 'lcauth\LCAuthController@logout')->name('logout');

// Route::get('/register', 'lcauth\LCRegisterController@showRegistrationForm');
// Route::post('/register', 'lcauth\LCRegisterController@register')->name('register');

Route::get('/', 'PagesController@index');

//reject request if user didn't login,redirect to 'login' or showLoginForm
Route::middleware(['auth'])->group(function () {
  Route::get('/dashboard', 'PagesController@dashboard')->name('dashboard');

  //Route::get('/locations/delete/{id}','LocationsController@delete');
  Route::post('/locations/delete','LocationsController@delete');
  Route::resource('locations','LocationsController');

  Route::get('/cows','CowsController@index')->name('cows.index');
  Route::get('/cows/create','CowsController@create')->name('cows.create');
  Route::post('/cows','CowsController@store')->name('cows.save');
  Route::get('/cows/{id}/edit','CowsController@edit')->name('cows.edit');
  Route::delete('/cows/{cow_id}', 'CowsController@destroy')->name('cows.destroy');
  Route::post('/cows/search','CowsController@search')->name('cows.search');
  Route::get('cows/searchdam','CowsController@searchdam')->name('cows.searchdam');
  Route::get('cows/searchsire','CowsController@searchsire')->name('cows.searchsire');
  Route::get('cows/search_cow_tree','CowsController@search_cow_tree')->name('cows.searchcowtree');
  Route::get('cows/exportcowstocsv','CowsController@exportcowstocsv');
  Route::get('cows/cowregistration','CowsController@cowregistration');
  Route::post('cows/searchforregistration','CowsController@searchforregistration')->name('cows.searchforregistration');
  Route::post('/cowsales','CowSalesController@storecowsale')->name('cowsales.savecowsalebycow');
  Route::post('/cowsales/deletebycow','CowSalesController@deletebycow')->name('cowsales.deletecowsalebycow');
  Route::post('cowsales/getcowbystatus','CowSalesController@getcowbystatus')->name('cowsales.getcowbystatus');
  Route::post('cows/getchildcowfromparentid','CowsController@getChildCowFromParentId')->name('cows.getchildcowfromparentid');

  Route::get('/cows/compactview/{cow_id}','CowsController@compactview');
  Route::get('/pdf/cowpedigreepdf/{cow_id}','PdfController@cowpedigreepdf');
  Route::post('/pdf/cowregistrationformpdf','PdfController@cowregistrationformpdf');

  Route::post('uploadimage', 'UploadImageController@store')->name('uploadcowimage');

  Route::get('cows/{id}/cowsale','CowSalesController@cowsalebycow')->name('cows.cowsale');

  Route::get('/customers','CustomersController@index')->name('customers.index');
  Route::get('/customers/create','CustomersController@create')->name('customers.create');
  Route::get('/customers/{id}/edit','CustomersController@edit')->name('customers.edit');
  Route::post('/customers/search','CustomersController@search')->name('customers.search');
  Route::post('/customers','CustomersController@store')->name('customers.save');
  Route::get('/customers/{id}/cowsale','CowSalesController@cowsalebycustomer')->name('customers.cowsale');
  Route::post('/customers/dosearchforcowsalebycow','CustomersController@dosearchforcowsalebycow');

//Start Admin Section
  Route::middleware(['is_admin'])->group(function () {
    Route::get('/users','UsersController@index')->name('users.index');
    Route::get('/users/create','UsersController@create')->name('users.create');
    Route::get('/users/{id}/edit','UsersController@edit')->name('users.edit');
    Route::post('/users/store','UsersController@store')->name('users.store');
  });
//End Admin Section

  Route::get('/users/changepassword','UsersController@changepassword')->name('users.changepassword');

  Route::post('/users/changepassword','UsersController@storepassword')->name('users.storepassword');
});



