
<?php $__env->startSection('title',' - User'); ?>
<?php $__env->startSection('add_to_head'); ?>
  <link rel='stylesheet' href="<?php echo e(asset('css/lc_cow.css')); ?>">  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<form method="POST" action="<?php echo e(route('users.store')); ?>" accept-charset="UTF-8" id="saveForm">
  <?php echo e(csrf_field()); ?>

  <input type="hidden" id="user_id" name="user_id" value="<?php echo e($user->id); ?>">
  <div class="form-group row mt-3">
    <label class="col-sm-2 col-form-label text-end">Username</label>
    <div class="col-sm-3">
      <?php if($user->id!=0): ?>
        <label class="col-form-label text-start" style="font-size: 120%"><?php echo e($user->username); ?></label>
        <input id="username" name="username" type="text" class="form-control" style="display:none" placeholder="Username" value="<?php echo e($user->username); ?>">
      <?php else: ?>
        <input id="username" name="username" type="text" class="form-control" placeholder="Username" value="<?php echo e($user->username); ?>">
      <?php endif; ?>
    </div>
    <div class="col-sm-3 ms-0 ps-0 mt-2">
      <label id="error_username" class="text-danger" style="display: none">Username is required</label>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-sm-2 col-form-label text-end">Name</label>
    <div class="col-sm-3">
      <input id="name" name="name" type="text" class="form-control" placeholder="Name" value="<?php echo e($user->name); ?>">
    </div>
    <div class="col-sm-3 ms-0 ps-0 mt-2">
      <label id="error_name" class="text-danger" style="display: none">Name is required</label>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-sm-2 col-form-label text-end">Password</label>
    <div class="col-sm-3">
      <input id="password" name="password" type="password" class="form-control" placeholder="Password">
    </div>
    <div class="col-sm-4 ms-0 ps-0 mt-2">
      <i class="fas fa-eye-slash" id="showPassword"></i>
      <label id="error_password" class="text-danger" style="display: none">Password is required</label>
    </div>
  </div>
  <div class="form-group row mt-2">
    <div class="col-sm-2"></div>
    <div class="col-sm-3">
      <input id="is_admin" name="is_admin" type="checkbox" class="form-check-input" value="1" <?php if($user->is_admin==1): ?>checked <?php endif; ?>>
      <label class="form-check-label ps-1">Admin</label>
    </div>
  </div>
  <div class="form-group row mt-2">
    <div class="col-sm-2"></div>    
    <div class="col-sm-3">
      <input id="is_active" name="is_active" type="checkbox" class="form-check-input" value="1" <?php if($user->is_active==1): ?>checked <?php endif; ?>>
      <label class="form-check-label ps-1">Active</label>
    </div>
  </div>  
  <!-- Button trigger modal -->
  <div class="form-group row mt-3">
    <div class="col-sm-2"></div>
    <div class="col-sm-3 d-flex justify-content-start">
      <button id="saveButton" type="button" class="btn btn-primary me-2" >บันทึก</button>
      <button class="btn btn-outline-secondary" onclick="history.back(-1)" type="button">ยกเลิก</button>
    </div>
  </div>
</form>
<!-- Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmModalLabel">บันทึกข้อมูล</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ต้องการบันทึกข้อมูล User
      </div>
      <div class="modal-footer">
        <button id="confirmModalSaveButton" type="button" class="btn btn-primary">บันทึก</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        
      </div>
    </div>
  </div>
</div>

<script>

    $(document).ready(function(){        
        $('#saveButton').click(function(e){
            if(checkValidation())
            {
              $("#confirmModal").modal('show');
            }
        });

        $("#confirmModalSaveButton").click(function(){
            $('#saveForm').submit();
        });

        function checkValidation(){
            var isValid = false;
            $('#username').val($('#username').val().trim());
            $('#name').val($('#name').val().trim());
            $('#error_username').hide();
            $('#error_name').hide();
            $('#error_password').hide();
            if($('#username').val() == "")
            {
              $('#error_username').show();
            }
            else if($('#name').val() == "")
            {
              $('#error_name').show();
            }
            else if($('#user_id').val() == "0" && $('#password').val() == "")
            {
              $('#error_password').show();
            }
            else 
            {
              $('#error_message').hide();
              isValid = true;
            }

            return isValid;
        }
        $(document).on("click", "#showPassword",function(e){
          e.preventDefault();       
          if($("#password").attr("type")=="password")
          {
            $("#password").attr("type","text");
            $("#password_confirmation").attr("type","text");
            $("#showPassword").removeClass("fas fa-eye-slash");
            $("#showPassword").addClass("fas fa-eye");
          }
          else{
            $("#password").attr("type","password");
            $("#password_confirmation").attr("type","password");
            $("#showPassword").removeClass("fas fa-eye");
            $("#showPassword").addClass("fas fa-eye-slash");
          }
            
        });
    });    
</script>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp608025/public_html/lcapp/resources/views/users/createorupdate.blade.php ENDPATH**/ ?>