<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
 
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name','Cow Management')); ?></title>
        <link rel='stylesheet' href="<?php echo e(asset('css/app.css')); ?>">
        <link rel='stylesheet' href="<?php echo e(asset('css/lc_app.css')); ?>">

        <link href="<?php echo e(asset('vendor/fontawesome-free/css/solid.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('vendor/fontawesome-free/css/fontawesome.min.css')); ?>" rel="stylesheet">
        <script src="<?php echo e(asset('js/jquery-3.5.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/lc_app.js')); ?>"></script>
    <?php if($useDatePicker??false): ?>
        <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>">
        <script src="<?php echo e(asset('js/jquery-ui-1.11.4.custom.js')); ?>"></script>
        <link rel="stylesheet" href="<?php echo e(asset('css/lc_datepicker.css')); ?>">
        <script src="<?php echo e(asset('js/lc_datepicker.js')); ?>"></script>
    <?php endif; ?>
    <?php if($useTreeView??false): ?>
        <link rel="stylesheet" href="<?php echo e(asset('css/lc_cowtree.css')); ?>">
        <script src="<?php echo e(asset('js/lc_cowtree.js')); ?>"></script>
    <?php endif; ?>
    </head>
    <body>
        <!-- Page Wrapper -->
        <div id="wrapper">
            <?php echo $__env->make('inc.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Content Wrapper -->
            <div id="content-wrapper" class="d-flex flex-column">
                <!-- Main Content -->
                <div id="content">
                    <?php echo $__env->make('inc.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Begin Page Content -->
                    <div class="container-fluid content-bg pb-2">
                        <?php echo $__env->make('inc.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                    <!-- End Page Content -->
                </div>
                <!-- End Main Content -->
            </div>
            <!-- End Content Wrapper -->
        </div>
        <!-- End Page Wrapper -->
        
        
    </body>
</html>
<?php /**PATH /home/cp608025/public_html/lcapp/resources/views/layouts/oldapp.blade.php ENDPATH**/ ?>