<?php $__env->startSection('title',' - ข้อมูลซื้อวัว'); ?>
<?php $__env->startSection('add_to_head'); ?>
  <link rel='stylesheet' href="<?php echo e(asset('css/lc_cow.css')); ?>">
  
  <!-- for Date Picker -->
  <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>">
  <script src="<?php echo e(asset('js/jquery-ui-1.11.4.custom.js')); ?>"></script>
  <link rel="stylesheet" href="<?php echo e(asset('css/lc_datepicker.css')); ?>">
  <script src="<?php echo e(asset('js/lc_datepicker.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<form method="POST" action="<?php echo e(action('CowSalesController@storecowsale')); ?>" accept-charset="UTF-8" autocomplete="off" id="saveForm">
  <?php echo csrf_field(); ?>
  <input type="hidden" value="<?php echo e($cowData->cow_id??''); ?>" id="cow_id" name="cow_id">

<div id="cowDiv" class="container-xxl border px-3 pt-2" >
  <div class="row">
    <div id="cowDivInfo" class="col-10">
      <div class="row mt-2">
        <label class="col-2 labelBold">หมายเลขตัววัว</label>
        <label class="col-1 labelContent"><?php echo e($cowData->private_herd_no ?? '-'); ?></label>
        <label class="col-2 labelBold">เลขทะเบียนวัว</label>
        <label class="col-1 labelContent"><?php echo e($cowData->regisno1 ?? '-'); ?></label>
        <label class="col-2 labelBold">ชื่อวัว</label>
        <label class="col-4 labelContent"><?php echo e($cowData->cow_name ?? ''); ?></label>
      </div>
      <div class="row mt-2">
        <label class="col-2 labelBold">เพศ</label>
        <label class="col-1 labelContent"><?php echo e(($cowData->sex)?'Cow':'Bull'); ?></label>
        <label class="col-2 labelBold">พันธุ์</label>
        <label class="col-1 labelContent"><?php echo e(($cowData->breed==1)?'Brahman':(($cowData->breed==2)?'Crossbred':'Brangus')); ?></label>
        <label class="col-2 labelBold">สี</label>
        <label class="col-1 labelContent"><?php echo e(($cowData->color)?'Grey':'Red'); ?></label>
      </div>
      <div class="row mt-2">
        <label class="col-2 labelBold">วันเกิด</label>
        <label class="col-4 labelContent"><?php echo e($cowData->birth_date); ?> (อายุ <?php echo e($cowData->age_in_months); ?> เดือน)</label>
      </div>
    </div>
    <div id="cowImage" class="col-2">
      <img id="cowimage" src="<?php echo e('/storage/cow_images/'.$cowimageData->cow_image_path??'/storage/cow_image/noimage.jpg'); ?>" class="rounded img-fluid border border-secondary" style="max-height:130px;" >
    </div>
  </div>
</div>
<div id="customerDiv" class="container-xxl px-3 pt-2 mt-1 border">
  <input type="hidden" value="<?php echo e($cowBuyData!=null?$cowBuyData->customer_id:0); ?>" id="customer_id" name="customer_id">
  <div class="row row-cols-2 mt-1">
    <label class="col-1 labelBold pt-2  pe-1">ชื่อลูกค้า</label>
    <div class="col-5 d-flex">
      <input class="form-control" type="text" id="customer_name" name="customer_name" value="<?php echo e($cowBuyData!=null?$cowBuyData->customer_name:''); ?>"  readonly style="height: 35px;">
      <a class="rounded btnsearch ms-1" id="btnSearchCustomer" style="width: 35px; height: 35px;text-align: center;vertical-align: middle;" data-bs-toggle='modal' data-bs-target='#searchCustomerModal'>
        <i class="fas fa-search"></i>
      </a>
      <a class="rounded btnsearch ms-1" id="btnAddCustomer" style="width:100px;height: 35px;text-align: center;vertical-align: middle;" data-bs-toggle='modal' data-bs-target='#AddCustomerModal'>
        เพิ่มลูกค้า
      </a>
    </div>
    <label class="col-1 labelBold pt-2 pe-1">โทรศัพท์</label>
    <div class="col-5 pe-2">
      <input class="form-control" type="text" id="customer_phone_no" name="customer_phone_no" value="<?php echo e(($cowBuyData->customer_phone_no=='undefined')?'':$cowBuyData->customer_phone_no); ?>" style="height: 35px;">
    </div>
  </div>
  <div class="row row-cols-2 mt-1">
    <label class="col-1 labelBold pt-2 pe-2">ที่อยู่</label>
    <div class="col-5 pe-2">
      <textarea class="form-control" id="customer_address1" name="customer_address1" style="height: 80px;"><?php echo e(($cowBuyData->customer_address1=='undefined')?'':$cowBuyData->customer_address1); ?></textarea>
    </div>
    <label class="col-1 labelBold pt-2">Note</label>
    <div class="col-5 pe-2">
      <textarea class="form-control" id="customer_note" name="customer_note" style="height: 80px;"><?php echo e(($cowBuyData->customer_note=='undefined')?'':$cowBuyData->customer_note); ?></textarea>
    </div>
  </div>
  <div class="row row-cols-2 mt-1">
    <label class="col-1 labelBold pt-2 pe-2">จังหวัด</label>
    <div class="col-5 pe-2">
      <select name="customer_province_id" id="customer_province_id" class='form-control'>
        <option value="0">--- Select ---</option>
        <?php if(isset($provinceData) and count($provinceData)>0): ?>
          <?php $__currentLoopData = $provinceData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($province->province_id); ?>" <?php echo e(($cowBuyData->customer_province_id==$province->province_id)?'selected':''); ?>><?php echo e($province->name_th); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </select>
    </div>
  </div>
</div>
<div id="orderDiv" class="container-xxl px-3 pt-2 mt-1 border">
  <div class="row mt-1">
    <label class="col-1 labelBold pt-2">วันที่จองวัว</label>
    <div class="col-2 pe-2">
      <input class="datepicker cowInput form-control" placeholder="" id="booking_date" name="booking_date" data-date="<?php echo e($cowBuyData!=null?$cowBuyData->booking_date:''); ?>" type="text"> 
    </div>
    <div class="col-3">
    </div>
    <div class="col-1">
    </div>
    <div class="col-4 pt-1 ps-0">
      <input  type="checkbox" id="use_same_address" name="use_same_address" value="1"  <?php echo e($cowBuyData->use_same_address==0?'':'checked'); ?>>
      <label for="use_same_address">ใช้ที่อยู่จัดส่งเดียวกับที่อยู่ลูกค้า</label><br>
    </div>
  </div>
  <div class="row mt-1">
    <label class="col-1 labelBold pt-2">วันที่จ่ายเงิน</label>
    <div class="col-2 pe-2">
      <input class="datepicker cowInput form-control" placeholder="" id="paid_date" name="paid_date" data-date="<?php echo e($cowBuyData!=null?$cowBuyData->paid_date:''); ?>" type="text">
    </div>
    <div class="col-3">
    </div>
      
    <label class="col-1 labelBold pt-2">ที่อยู่จัดส่ง</label>
    <div class="col-4">
      <input class="form-control" type="text" id="cow_sale_address1" name="cow_sale_address1" value="<?php echo e(($cowBuyData->cow_sale_address1=='undefined')?'':$cowBuyData->cow_sale_address1); ?>" placeholder="ที่อยู่จัดส่ง">
    </div>
  </div>
  <div class="row mt-1">
    <label class="col-1 labelBold pt-2">วันที่ส่งวัว</label>
    <div class="col-2 pe-2">
      <input class="datepicker cowInput form-control" placeholder="" id="delivery_date" name="delivery_date" data-date="<?php echo e($cowBuyData!=null?$cowBuyData->delivery_date:''); ?>" type="text">
    </div>
    <div class="col-3">
    </div>
    
    <label class="col-1 labelBold pt-2">จังหวัด</label>
    <div class="col-4">
      <select name="cow_sale_province_id" id="cow_sale_province_id" class='form-control'>
        <option value="0">--- Select ---</option>
        <?php if(isset($provinceData) and count($provinceData)>0): ?>
          <?php $__currentLoopData = $provinceData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($province->province_id); ?>" <?php echo e(($cowBuyData->cow_sale_province_id==$province->province_id)?'selected':''); ?>><?php echo e($province->name_th); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </select>
    </div>
  </div>
  <div class="row mt-1">
    <label class="col-1 labelBold pt-2">วันที่ส่งเอกสาร</label>
    <div class="col-2 pe-2">
      <input class="datepicker cowInput form-control" placeholder="" id="send_doc_date" name="send_doc_date" data-date="<?php echo e($cowBuyData!=null?$cowBuyData->send_doc_date:''); ?>" type="text">
    </div>
    <div class="col-3">
    </div>

    <label class="col-1 labelBold pt-2">โทรศัพท์</label>
    <div class="col-4">
      <input class="form-control" type="text" id="cow_sale_phone_no" name="cow_sale_phone_no" value="<?php echo e(($cowBuyData->cow_sale_phone_no=='undefined')?'':$cowBuyData->cow_sale_phone_no); ?>" placeholder="เบอร์โทรศัพท์จัดส่ง">
    </div>
  </div>
  <div class="row m-1">
    <div class="col-1"></div>
    <div class="col-4 py-2">
      <button class="btn btn-primary" id="saveButton" name="saveButton" type="button">บันทึก</button>
      <button class="btn btn-outline-secondary" id="btnCancel" type="button">ยกเลิก</button>
      <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#confirmDeleteModal" type="button">ลบข้อมูลการซื้อวัว</button>    
    </div>
  </div>
</form>

  <!-- Modal Confirm-->
  <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmModalLabel">บันทึกข้อมูล</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          ต้องการบันทึกข้อมูลการขายวัว
        </div>
        <div class="modal-footer">
          <button type="button" id="btnConfirmCowSaleSave" class="btn btn-primary">บันทึกข้อมูล</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        </div>
      </div>
    </div>
  </div>
  <!-- Modal Delete Cow Sale-->
  <div class="modal fade" id="confirmDeleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmModalLabel">ลบข้อมูลขายวัว</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          ต้องการลบข้อมูลการขายวัว
        </div>
        <div class="modal-footer">
          <button type="button" id="btnConfirmDeleteCowSale" class="btn btn-primary">ลบข้อมูล</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        </div>
      </div>
    </div>
  </div>
  <!-- Modal search Customer-->
  <div class="modal fade" id="searchCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmModalLabel">ค้นหาลูกค้า</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          <div >          
            <input class="cowInput" placeholder="ชื่อลูกค้า" id="customer_name_search" name="customer_name_search" type="text">
            <a class="rounded btnsearch ms-1" id="btnDoSearchCustomer" style="width: 35px; height: 35px;text-align: center;vertical-align: middle;" >
              <i class="fas fa-search"></i>
            </a>
          </div>
          <div class="" style="height: 200px;overflow-y: scroll;">
            <table id="tableCustomerResult" class="table table-striped table-sm table-bordered table-hover mt-2">
              <thead>
                <tr class="thead-light">
                  <th scope="col" class="tableHeader"style="width:100px">ชื่อลูกค้า</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" id="btnConfirmSelectCustomer" class="btn btn-primary">เลือก</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        </div>
      </div>
    </div>
  </div>
  <!-- Modal Add Customer-->
  <div class="modal fade" id="AddCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmModalLabel">สร้างลูกค้า</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          </button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label for="customer_name_add">ชื่อลูกค้า</label>
            <input class="form-control" id="customer_name_add" placeholder="ชื่อลูกค้า">
          </div>
          <div class="form-group mt-1">
            <label for="address1_add">ที่อยู่ลูกค้า</label>
            <input class="form-control" id="address1_add" placeholder="ที่อยู่ลูกค้า">
          </div>
          <div class="form-group mt-1">
            <label for="province_id_add">จังหวัด</label>
            <select name="province_id_add" id="province_id_add" class='form-control'>
              <option value="0">--- Select ---</option>
              <?php if(isset($provinceData) and count($provinceData)>0): ?>
                <?php $__currentLoopData = $provinceData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($province->province_id); ?>"><?php echo e($province->name_th); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </select>
          </div>
          <div class="form-group mt-1">
            <label for="phone_no_add">เบอร์โทรศัพท์</label>
            <input class="form-control" id="phone_no_add" placeholder="เบอร์โทรศัพท์">
          </div>
          <div class="form-group mt-1">
            <label for="customer_note_add">หมายเหตุ</label>
            <input class="form-control" id="customer_note_add" placeholder="หมายเหตุ">
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" id="btnConfirmAddCustomer" class="btn btn-primary">สร้าง</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  $(document).ready(function(){

    if($("#customer_id").val()!="")
    {
      $("#booking_date").datepicker("setDate", $('#booking_date').data('date'));
      $("#paid_date").datepicker("setDate", $('#paid_date').data('date'));
      $("#delivery_date").datepicker("setDate", $('#delivery_date').data('date'));
      $("#send_doc_date").datepicker("setDate", $('#send_doc_date').data('date'));
    };

    $('#saveButton').click(function(){            
        if(ValidationBeforeSaveCowSale())
        {
          $("#confirmModal").modal('show');
        }
    });

    $("#btnConfirmCowSaleSave").click(function(){
      $("#cow_sale_province_id").prop("disabled", false);
      $('#saveForm').submit();
    });

    function ValidationBeforeSaveCowSale(){
      $('#customer_name').val($('#customer_name').val().trim());
      if($('#customer_id').val() == '' || $('#customer_id').val() == '0'){
            alert("ไม่ได้เลือก ข้อมูลลูกค้า");
            return false;
        }
      if($('#customer_name').val() == ''){
            alert("ไม่ได้กรอกข้อมูล ชื่อลูกค้า");
            return false;
        }
      if($('#booking_date').val() == ''){
            alert("ไม่ได้เลือกวันที่จองวัว");
            return false;
        }
      return true;
    }

    $("#btnConfirmDeleteCowSale").click(function(){
      var _token = $('input[name="_token"]').val();
      var $cow_id=$('#cow_id').val();
      var data = new FormData();
      data.append("_token", _token);
      data.append("cow_id",$cow_id); 

      $.ajax({
        url:"/cowsales/deletebycow",
        method:'POST',
        data:data,
        processData: false,
        contentType: false,
        success:function(data)
        {
          //window.location.href="/cows/"+$cow_id+"/edit";
          $("#customer_id").val('');
          $("#customer_name").val('');
          $("#customer_note").val('');
          ClearCustomerAddress();
          $("#use_same_address").prop('checked', true);
          SetCowSaleAddress();
          
          $("#booking_date").val('');
          $("#paid_date").val('');
          $("#delivery_date").val('');
          $("#send_doc_date").val('');
          $("#confirmDeleteModal").modal('hide');
        }
      });
    });

    $("#btnCancel").click(function(){
      event.preventDefault();
      if(document.referrer.includes('cows'))
        window.location.href='/cows/'+$('#cow_id').val()+'/edit';
      else
        close();
    });

    $( "#searchCustomerModal" ).on('show.bs.modal', function(){
      //clear previous data
      $("#customer_name_search").val('');
      $("#tableCustomerResult tbody tr[selected='selected']").css("background-color", "white");
      $("#tableCustomerResult tbody tr[selected='selected']").removeAttr("selected");
      $('#tableCustomerResult tbody').html('');
    });

    $(document).on ("click", "#tableCustomerResult tbody tr", function () {
      $("#tableCustomerResult tbody tr[selected='selected']").css("background-color", "white");
      $("#tableCustomerResult tbody tr[selected='selected']").removeAttr("selected");
      $(this).attr( "selected", "selected" );
      $(this).css("background-color", "LightBlue");
    });

    $("#btnDoSearchCustomer").click(function(){
      DoSearchCustomer();
    });

    $("#customer_name_search").keypress(function(e){
      if (e.which == 13) {
        DoSearchCustomer();
      }
    });
    
    function DoSearchCustomer(){
      var _token = $('input[name="_token"]').val();
      var data = new FormData();
      data.append("_token", _token);
      data.append("customer_name",$('#customer_name_search').val()); 

      $.ajax({
        url:"/customers/dosearchforcowsalebycow",
        method:'POST',
        data:data,
        processData: false,
        contentType: false,
        success:function(data)
        {
          var output=JSON.parse(data);
          $('#tableCustomerResult tbody').html(CreateHTMLSearchCustomerResult(output.customers));
        },
        error: function(xhr, status, error){
         alert('Error - ' + error);
        }
      });
    };
    function CreateHTMLSearchCustomerResult(customrs){
      $output='';
      if(customrs.length >0){
        for(var i =0;i < customrs.length;i++)
        {
          $output += "<tr data-id='"+customrs[i].customer_id+"' data-address1='"+customrs[i].address1+
          "'data-province_id='"+customrs[i].province_id+
          "'data-phone_no='"+customrs[i].phone_no+
          "'data-note='"+customrs[i].note+ "'><td class='tableDetail'>"+customrs[i].customer_name+"</td></tr>";
        }
      }    
      return $output;
    };

    $("#btnConfirmSelectCustomer").click(function(){
      DoSelectCustomer();
    });

    $(document).on ("dblclick", "#tableCustomerResult tbody tr", function () {
      DoSelectCustomer();
    });

    function DoSelectCustomer(){
      
      $("#customer_id").val($("#tableCustomerResult tbody tr[selected='selected']").data("id"));
      $("#customer_name").val($("#tableCustomerResult tbody tr[selected='selected'] td").html());
      $("#customer_address1").val($("#tableCustomerResult tbody tr[selected='selected']").data("address1"));
      $("#customer_province_id").val($("#tableCustomerResult tbody tr[selected='selected']").data("province_id"));
      $("#customer_phone_no").val($("#tableCustomerResult tbody tr[selected='selected']").data("phone_no"));
      $("#customer_note").val($("#tableCustomerResult tbody tr[selected='selected']").data("note"));
      $("#searchCustomerModal").modal('hide');
      ClearCowSaleAddress();
      $("#use_same_address").prop('checked', true);
          SetCowSaleAddress();
    };

    $("#btnConfirmAddCustomer").click(function(){
      if(ValidationBeforeAddCustomer())
        AddCustomer();
    });

    function ValidationBeforeAddCustomer(){
      $('#customer_name_add').val($('#customer_name_add').val().trim());
    
      if($('#customer_name_add').val() == ''){
            alert("ไม่ได้กรอกข้อมูล ชื่อลูกค้า");
            return false;
        }
      return true;
    };

    function AddCustomer(){
      var _token = $('input[name="_token"]').val();
      var data = new FormData();
      data.append("_token", _token);
      data.append("customer_name",$('#customer_name_add').val());
      data.append("address1",$('#address1_add').val());
      data.append("province_id",$('#province_id_add').val());
      data.append("phone_no",$('#phone_no_add').val());
      data.append("note",$('#customer_note_add').val());
      data.append("add_from_model",'yes');
      $.ajax({
        url:"/customers",
        method:'POST',
        data:data,
        processData: false,
        contentType: false,
        success:function(data)
        {
          var output=JSON.parse(data);
          $("#customer_id").val(output.customer.customer_id);
          $("#customer_name").val(output.customer.customer_name);
          $("#customer_address1").val(output.customer.address1);
          $("#customer_province_id").val(output.customer.province_id);
          $("#customer_phone_no").val(output.customer.phone_no);
          $("#customer_note").val(output.customer.note);
          $("#customer_name_add").val('');
          $("#address1_add").val('');
          $("#province_id_add").val('');
          $("#phone_no_add").val('');
          $("#customer_note_add").val('');
          $("#AddCustomerModal").modal('hide');
          ClearCowSaleAddress();
          $("#use_same_address").prop('checked', true);
          SetCowSaleAddress();
        },
        error: function(xhr, status, error){
         alert('Error - ' + error);
        }
      });
    };

    function ClearCustomerAddress(){
      $("#customer_address1").val('');
      $("#customer_province_id").val('');
      $("#customer_phone_no").val('');
    };

    function ClearCowSaleAddress(){
      $("#cow_sale_address1").val('');
      $("#cow_sale_province_id").val('');
      $("#cow_sale_phone_no").val('');
    };

    function EnableCowSaleAdressTextbox(isEnable){
      $("#cow_sale_address1").prop("readonly",!isEnable);
      $("#cow_sale_province_id").prop("disabled", !isEnable);
      $("#cow_sale_phone_no").prop("readonly",!isEnable);
    };

    function CopyAddress(){
      $("#cow_sale_address1").val($("#customer_address1").val());
      $("#cow_sale_province_id").val($("#customer_province_id").val());
      $("#cow_sale_phone_no").val($("#customer_phone_no").val());
    };

    function SetCowSaleAddress(){
      if($("#use_same_address").prop('checked')) {
        EnableCowSaleAdressTextbox(false);
        CopyAddress();
      }
      else{
        EnableCowSaleAdressTextbox(true);
      };
    };

    $(document).on ("change", "#use_same_address", function () {
      SetCowSaleAddress();
    });

    $("#customer_address1,#customer_phone_no").keyup(function(){
      SetCowSaleAddress();
    });
    $("#customer_province_id").change(function(){
      SetCowSaleAddress();
    });
  })
</script>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp608025/public_html/lcapp/resources/views/cows/cowsalebycow.blade.php ENDPATH**/ ?>