<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
 
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name','Cow Management')); ?></title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.ico')); ?>" />
        <!-- Font Awesome icons (free version)-->
        <script src="https://use.fontawesome.com/releases/v5.15.3/js/all.js" crossorigin="anonymous"></script>
        <!-- Google fonts-->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Prompt:wght@400;700&display=swap" rel="stylesheet"> 
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet" />
        <link rel='stylesheet' href="<?php echo e(asset('css/lc_app.css')); ?>">
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="<?php echo e(asset('css/dashboard_styles.css')); ?>" rel="stylesheet" />
              
        <script src="<?php echo e(asset('js/jquery-3.5.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></script>
        
        <script src="<?php echo e(asset('js/lc_app.js')); ?>"></script>
        <!-- Core theme JS-->
        <script src="<?php echo e(asset('js/dashboard_scripts.js')); ?>"></script>  

        <?php if($useDatePicker??false): ?>
            <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>">
            <script src="<?php echo e(asset('js/jquery-ui-1.11.4.custom.js')); ?>"></script>
            <link rel="stylesheet" href="<?php echo e(asset('css/lc_datepicker.css')); ?>">
            <script src="<?php echo e(asset('js/lc_datepicker.js')); ?>"></script>
        <?php endif; ?>
        
        <?php if($useTreeView??false): ?>
            <link rel="stylesheet" href="<?php echo e(asset('css/lc_cowtree.css')); ?>">
            <script src="<?php echo e(asset('js/lc_cowtree.js')); ?>"></script>
        <?php endif; ?>
    </head>
    <body>
      <?php echo $__env->make('inc.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <!-- Begin Page Content -->
      <div class="container-fluid">
        <?php echo $__env->make('inc.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
      </div>
      <!-- End Page Content -->      

    </body>
</html><?php /**PATH /home/cp608025/public_html/lcapp/resources/views/layouts/oldappV2.blade.php ENDPATH**/ ?>